package cn.schoolwow.quickdao.flow.executor;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.entity.SqlLog;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.executor.common.BeforeExecuteFlow;
import cn.schoolwow.quickdao.flow.executor.common.ExecuteFailFlow;
import cn.schoolwow.quickdao.flow.executor.common.InsertSqlLogFlow;
import cn.schoolwow.quickdao.flow.executor.common.SetPrepareStatementParameterFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class ExecuteQueryConnectionFlow implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(ExecuteQueryConnectionFlow.class);

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new BeforeExecuteFlow());
        executeQuery(flowContext);
    }

    @Override
    public String name() {
        return "执行查询语句";
    }

    private void executeQuery(FlowContext flowContext) throws Exception {
        String name = (String) flowContext.checkData("name");
        String sql = (String) flowContext.checkData("sql");
        String formatSQL = (String) flowContext.checkData("formatSQL");
        ResultSetConsumer resultSetConsumer = (ResultSetConsumer) flowContext.useData("resultSetConsumer");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");

        flowContext.putTemporaryData("startTime", System.currentTimeMillis());
        try (Connection connection = quickDAOConfig.databaseContext.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);
        ) {
            flowContext.startFlow(new SetPrepareStatementParameterFlow())
                    .putTemporaryData("preparedStatement", preparedStatement)
                    .execute();
            try (ResultSet resultSet = preparedStatement.executeQuery();) {
                flowContext.startFlow(new InsertSqlLogFlow())
                        .putTemporaryData("sqlLogType", 0)
                        .execute();
                SqlLog sqlLog = (SqlLog) flowContext.checkData("sqlLog");
                logger.debug("[查询]名称:{},耗时:{}ms,执行语句:{}", name, sqlLog.getConsumeTime(), formatSQL);
                if(quickDAOConfig.logRecordOption.record&&!"插入SQL日志".equalsIgnoreCase(name)){
                    quickDAOConfig.logRecordOption.sqlRecordBuilder.append("[查询]名称:"+name+",耗时:"+sqlLog.getConsumeTime()+"ms,执行语句:"+formatSQL+"\r\n");
                }
                resultSetConsumer.consumeResultSet(resultSet);
            }
        } catch (Exception e) {
            flowContext.startFlow(new InsertSqlLogFlow())
                    .next(new ExecuteFailFlow())
                    .putTemporaryData("exception", e)
                    .putTemporaryData("sqlLogType", 0)
                    .execute();
            throw e;
        }finally {
            flowContext.removeData("parameters");
        }
    }

}
