package cn.schoolwow.quickdao.flow.entity.annotation;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.Set;

public class CheckCompositePropertyFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Class clazz = (Class) flowContext.checkData("clazz");

        Set<String> packageNameSet = quickDAOConfig.entityOption.packageNameMap.keySet();
        for (String packageName : packageNameSet) {
            if (clazz.getName().contains(packageName)) {
                flowContext.putData("compositeProperty", true);
                return;
            }
        }
        Set<Class> classSet = quickDAOConfig.entityOption.entityClassMap.keySet();
        for (Class c : classSet) {
            if (c.getName().equals(clazz.getName())) {
                flowContext.putData("compositeProperty", true);
                return;
            }
        }
        flowContext.putData("compositeProperty", false);
    }

    @Override
    public String name() {
        return "判断是否为实体包类";
    }
}
