package cn.schoolwow.quickdao.flow.dql.response.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.dql.QueryColumnTypeMapping;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickdao.domain.internal.dql.subquery.SubQueryOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;

public class GetResultSetArrayFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setResultSetPropertyList(flowContext);
        matchEntity(flowContext);
        matchQueryContext(flowContext);
        matchQueryColumnTypeMapping(flowContext);
        setResultSetArray(flowContext);
    }

    @Override
    public String name() {
        return "获取ResultSet变为JSONArray";
    }

    private void setResultSetPropertyList(FlowContext flowContext) throws SQLException {
        ResultSet resultSet = (ResultSet) flowContext.checkData("resultSet");

        ResultSetMetaData metaData = resultSet.getMetaData();
        Property[] resultSetPropertyArray = new Property[metaData.getColumnCount()];
        for (int i = 1; i <= resultSetPropertyArray.length; i++) {
            resultSetPropertyArray[i - 1] = new Property();
            resultSetPropertyArray[i - 1].columnLabel = metaData.getColumnLabel(i);
            resultSetPropertyArray[i - 1].column = metaData.getColumnName(i);
            resultSetPropertyArray[i - 1].columnType = metaData.getColumnTypeName(i);
            resultSetPropertyArray[i - 1].className = metaData.getColumnClassName(i);
            resultSetPropertyArray[i - 1].entity = new Entity();
            resultSetPropertyArray[i - 1].entity.tableName = metaData.getTableName(i);
        }
        flowContext.putData("resultSetPropertyArray", resultSetPropertyArray);
    }

    private void matchEntity(FlowContext flowContext){
        Entity entity = (Entity) flowContext.getData("entity");
        if(null==entity){
            return;
        }
        Property[] resultSetPropertyArray = (Property[]) flowContext.checkData("resultSetPropertyArray");
        for(Property property:entity.properties){
            for(Property resultSetProperty:resultSetPropertyArray){
                if(!resultSetProperty.entity.tableName.equalsIgnoreCase(entity.tableName)){
                    continue;
                }
                if(resultSetProperty.columnLabel.equalsIgnoreCase(property.name)||resultSetProperty.columnLabel.equalsIgnoreCase(property.column)){
                    resultSetProperty.clazz = property.clazz;
                    break;
                }
            }
        }
    }

    private void matchQueryContext(FlowContext flowContext){
        QueryContext queryContext = (QueryContext) flowContext.getData("queryContext");
        if(null==queryContext){
            return;
        }
        Property[] resultSetPropertyArray = (Property[]) flowContext.checkData("resultSetPropertyArray");
        //主表
        {
            Entity entity = queryContext.queryOption.queryTableOption.entity;
            if(null!=entity){
                String tableAliasName = queryContext.queryOption.queryTableOption.tableAliasName;
                for(Property property:entity.properties){
                    for(Property resultSetProperty:resultSetPropertyArray){
                        if(!resultSetProperty.entity.tableName.equalsIgnoreCase(entity.tableName)){
                            continue;
                        }
                        if(resultSetProperty.columnLabel.equalsIgnoreCase(tableAliasName+"_"+property.column)
                                ||resultSetProperty.column.equalsIgnoreCase(property.column)
                        ){
                            resultSetProperty.clazz = property.clazz;
                            break;
                        }
                    }
                }
            }
        }
        //子表
        for(SubQueryOption subQueryOption:queryContext.queryOption.subQueryOptionList){
            Entity entity = subQueryOption.subQueryTableOption.entity;
            if(null!=entity){
                String tableAliasName = subQueryOption.subQueryTableOption.tableAliasName;
                for(Property property:entity.properties){
                    for(Property resultSetProperty:resultSetPropertyArray){
                        if(!resultSetProperty.entity.tableName.equalsIgnoreCase(entity.tableName)){
                            continue;
                        }
                        if(resultSetProperty.columnLabel.equalsIgnoreCase(tableAliasName+"_"+property.column)
                                ||resultSetProperty.column.equalsIgnoreCase(property.column)
                        ){
                            resultSetProperty.clazz = property.clazz;
                            break;
                        }
                    }
                }
            }
        }
        flowContext.putTemporaryData("queryColumnTypeMapping", queryContext.queryOption.queryColumnOption.queryColumnTypeMapping);
        flowContext.putTemporaryData("queryColumnTypeMap", queryContext.queryOption.queryColumnOption.queryColumnTypeMap);
    }

    private void matchQueryColumnTypeMapping(FlowContext flowContext){
        Property[] resultSetPropertyArray = (Property[]) flowContext.checkData("resultSetPropertyArray");
        Map<String,Class> queryColumnTypeMap = (Map<String, Class>) flowContext.getData("queryColumnTypeMap");

        if(null!=queryColumnTypeMap){
            for(Property resultSetProperty:resultSetPropertyArray){
                if(queryColumnTypeMap.containsKey(resultSetProperty.columnLabel)||queryColumnTypeMap.containsKey(resultSetProperty.column)){
                    resultSetProperty.clazz = queryColumnTypeMap.get(resultSetProperty.columnLabel);
                }
            }
        }

        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        QueryColumnTypeMapping queryColumnTypeMapping = (QueryColumnTypeMapping) flowContext.getData("queryColumnTypeMapping");
        if(null==queryColumnTypeMapping){
            queryColumnTypeMapping = quickDAOConfig.entityOption.queryColumnTypeMapping;
        }
        if(null!=queryColumnTypeMapping){
            for(Property resultSetProperty:resultSetPropertyArray){
                Class type = queryColumnTypeMapping.columnTypeMapping(resultSetProperty);
                if (null != type) {
                    resultSetProperty.clazz = type;
                }
            }
        }
    }

    private void setResultSetArray(FlowContext flowContext) throws SQLException {
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        ResultSet resultSet = (ResultSet) flowContext.checkData("resultSet");
        Long count = (Long) flowContext.getData("count");
        Property[] resultSetPropertyArray = (Property[]) flowContext.checkData("resultSetPropertyArray");

        JSONArray resultSetArray = (null==count)?new JSONArray():new JSONArray(count.intValue());
        while (resultSet.next()) {
            JSONObject resultSetObject = new JSONObject();
            for(Property property:resultSetPropertyArray){
                if(null==property.clazz){
                    resultSetObject.put(property.columnLabel, resultSet.getObject(property.columnLabel));
                    continue;
                }
                switch (property.clazz.getName()){
                    case "java.util.Date":{
                        resultSetObject.put(property.columnLabel, resultSet.getDate(property.columnLabel));
                    }break;
                    case "com.alibaba.fastjson.JSONObject":{
                        String jsonString = resultSet.getString(property.columnLabel);
                        resultSetObject.put(property.columnLabel, JSON.parseObject(jsonString));
                    }break;
                    case "com.alibaba.fastjson.JSONArray":{
                        String jsonString = resultSet.getString(property.columnLabel);
                        resultSetObject.put(property.columnLabel, JSON.parseArray(jsonString));
                    }break;
                    default:{
                        switch (databaseType){
                            case SQLite:{
                                resultSetObject.put(property.columnLabel, resultSet.getObject(property.columnLabel));
                            }break;
                            default:{
                                Object value = resultSet.getObject(property.columnLabel);
                                if(null!=value){
                                    resultSetObject.put(property.columnLabel, resultSet.getObject(property.columnLabel, property.clazz));
                                }
                            }
                        }
                    }break;
                }
            }
            resultSetArray.add(resultSetObject);
        }
        flowContext.putData("resultSetArray", resultSetArray);
    }
}
