package cn.schoolwow.quickdao.flow.dql.response.common;

import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.sql.ResultSet;

public class ExecuteConditionStatementFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.startFlow(new ExecuteQueryConnectionFlow())
                .putTemporaryData("name", "执行复杂查询")
                .putTemporaryData("resultSetConsumer", new ResultSetConsumer() {
                    @Override
                    public void consumeResultSet(ResultSet resultSet) throws Exception {
                        flowContext.startFlow(new GetResultSetArrayFlow())
                                .putData("resultSet", resultSet)
                                .execute();
                    }
                })
                .execute();
    }

    @Override
    public String name() {
        return "执行复杂查询";
    }

}
