package cn.schoolwow.quickdao.flow.dql.response;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.ArrayList;
import java.util.List;

public class UpdateFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        checkConstraint(flowContext);
        setStatement(flowContext);
        setParameters(flowContext);
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "根据查询条件更新记录";
    }

    private void checkConstraint(FlowContext flowContext){
        QueryContext queryContext = (QueryContext) flowContext.checkData("queryContext");

        if(null==queryContext.set){
            throw new IllegalArgumentException("请调用addUpdate方法指定需要更新的列!");
        }
    }

    private void setStatement(FlowContext flowContext) {
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        QueryContext queryContext = (QueryContext) flowContext.checkData("queryContext");

        StringBuilder sqlBuilder = new StringBuilder();
        switch (databaseType){
            case SQLite:{
                if(!queryContext.join.isEmpty()){
                    throw new IllegalArgumentException("SQLite数据库不支持update语句进行表连接操作!");
                }
                sqlBuilder.append("update " + quickDAOConfig.databaseContext.databaseProvider.escape(queryContext.queryOption.queryTableOption.entity.tableName) + " ");
                sqlBuilder.append(queryContext.set);
                sqlBuilder.append(queryContext.noAliasNameWhere);
            }break;
            default:{
                sqlBuilder.append("update " + quickDAOConfig.databaseContext.databaseProvider.escape(queryContext.queryOption.queryTableOption.entity.tableName) + " " + queryContext.queryOption.queryTableOption.tableAliasName + " ");
                sqlBuilder.append(queryContext.join);
                sqlBuilder.append(queryContext.set);
                sqlBuilder.append(queryContext.where);
            }break;
        }
        flowContext.putTemporaryData("sql", sqlBuilder.toString());
    }

    private void setParameters(FlowContext flowContext) {
        QueryContext queryContext = (QueryContext) flowContext.checkData("queryContext");

        List<Object> parameters = new ArrayList<>();
        parameters.addAll(queryContext.setParameters);
        parameters.addAll(queryContext.whereParameters);

        flowContext.putTemporaryData("parameters", parameters);
    }

    private void executeStatement(FlowContext flowContext) {
        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "根据查询条件更新记录")
                .execute();
    }

}
