package cn.schoolwow.quickdao.flow.dql.fetch;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.GetStatementSupplier;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.common.GetAndCacheStatementFlow;
import cn.schoolwow.quickdao.flow.dql.response.common.GetResultSetArrayFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.sql.ResultSet;
import java.util.ArrayList;

public class FetchNullFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setStatement(flowContext);
        setParameters(flowContext);
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "查询字段为NULL的记录";
    }

    private void setStatement(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");
        String column = (String) flowContext.checkData("column");

        String sqlCacheName = "fetchNull_" + entity.tableName + "_" + column + "_" + quickDAOConfig.databaseContext.databaseProvider.name();
        flowContext.startFlow(new GetAndCacheStatementFlow())
                .putTemporaryData("sqlCacheName", sqlCacheName)
                .putTemporaryData("getStatementSupplier", new GetStatementSupplier() {
                    @Override
                    public String getStatement() {
                        StringBuilder sqlBuilder = new StringBuilder("select ");
                        for(Property property:entity.properties){
                            sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column)+",");
                        }
                        sqlBuilder.deleteCharAt(sqlBuilder.length()-1);
                        sqlBuilder.append(" from " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName));
                        sqlBuilder.append(" where " + quickDAOConfig.databaseContext.databaseProvider.escape(column) + " is null");
                        return sqlBuilder.toString();
                    }
                })
                .execute();
    }

    private void setParameters(FlowContext flowContext) {
        flowContext.putTemporaryData("parameters", new ArrayList<>());
    }

    private void executeStatement(FlowContext flowContext) throws Exception {
        flowContext.startFlow(new ExecuteQueryConnectionFlow())
                .putTemporaryData("name", "查询字段为NULL的记录")
                .putTemporaryData("resultSetConsumer", new ResultSetConsumer() {
                    @Override
                    public void consumeResultSet(ResultSet resultSet) throws Exception {
                        flowContext.startFlow(new GetResultSetArrayFlow())
                                .putTemporaryData("resultSet", resultSet)
                                .execute();
                    }
                })
                .execute();
    }
}
