package cn.schoolwow.quickdao.flow.dql.condition.set;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickdao.domain.internal.dql.subquery.SubQueryOption;
import cn.schoolwow.quickdao.flow.dql.condition.get.GetFromConditionStatement;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.List;
import java.util.Map;
import java.util.Set;

public class SetJoinTableFragmentFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        QueryContext queryContext = (QueryContext) flowContext.checkData("queryContext");

        StringBuilder sqlBuilder = new StringBuilder();
        for(SubQueryOption subQueryOption:queryContext.queryOption.subQueryOptionList){
            //设置关联方式
            sqlBuilder.append(" " + subQueryOption.subQueryJoinTableOption.join + " ");
            //设置关联表信息
            if (null!=subQueryOption.subQueryTableOption.entity) {
                sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(subQueryOption.subQueryTableOption.entity.tableName));
            } else if(null!=subQueryOption.subQueryTableOption.joinCondition){
                FlowContext fromConditionFlowContext = flowContext.getQuickFlow().startFlow(new GetFromConditionStatement())
                        .putTemporaryData("fromCondition", subQueryOption.subQueryTableOption.joinCondition)
                        .execute();
                sqlBuilder.append("(" + fromConditionFlowContext.checkData("fromConditionStatement") + ")");
                List<Object> fromConditionParameters = (List<Object>) fromConditionFlowContext.getData("fromConditionParameters");
                queryContext.joinParameters.addAll(fromConditionParameters);
            }else{
                throw new IllegalArgumentException("当前关联查询存在异常!");
            }
            sqlBuilder.append(" " + subQueryOption.subQueryTableOption.tableAliasName);
            //设置关联表字段
            if (null != subQueryOption.subQueryJoinTableOption.primaryField && null != subQueryOption.subQueryJoinTableOption.joinTableField) {
                sqlBuilder.append(" on ");
                if (subQueryOption.subQueryJoinTableOption.parentSubQueryOption == null) {
                    //子表关联主表
                    sqlBuilder.append(subQueryOption.subQueryJoinTableOption.queryOption.queryTableOption.tableAliasName + "." + quickDAOConfig.databaseContext.databaseProvider.escape(subQueryOption.subQueryJoinTableOption.primaryField));
                } else {
                    //子表关联子表
                    sqlBuilder.append(subQueryOption.subQueryJoinTableOption.parentSubQueryOption.subQueryTableOption.tableAliasName + "." + quickDAOConfig.databaseContext.databaseProvider.escape(subQueryOption.subQueryJoinTableOption.primaryField));
                }
                sqlBuilder.append(" = " + subQueryOption.subQueryTableOption.tableAliasName + "." + quickDAOConfig.databaseContext.databaseProvider.escape(subQueryOption.subQueryJoinTableOption.joinTableField) + " ");

                if (!subQueryOption.subQueryJoinTableOption.onConditionMap.isEmpty()) {
                    Set<Map.Entry<String, String>> entrySet = subQueryOption.subQueryJoinTableOption.onConditionMap.entrySet();
                    for (Map.Entry<String, String> entry : entrySet) {
                        sqlBuilder.append(" and ");
                        if (subQueryOption.subQueryJoinTableOption.parentSubQueryOption == null) {
                            sqlBuilder.append(subQueryOption.subQueryJoinTableOption.queryOption.queryTableOption.tableAliasName + "." + quickDAOConfig.databaseContext.databaseProvider.escape(entry.getKey())
                                    + " = "
                                    + subQueryOption.subQueryTableOption.tableAliasName + "." + quickDAOConfig.databaseContext.databaseProvider.escape(entry.getValue()) + " ");
                        } else {
                            sqlBuilder.append(subQueryOption.subQueryTableOption.tableAliasName + "." + quickDAOConfig.databaseContext.databaseProvider.escape(entry.getValue())
                                    + " = "
                                    + subQueryOption.subQueryJoinTableOption.parentSubQueryOption.subQueryTableOption.tableAliasName + "." + quickDAOConfig.databaseContext.databaseProvider.escape(entry.getKey()) + " ");
                        }
                    }
                }
            }
        }
        if(sqlBuilder.length()>0){
            queryContext.join = sqlBuilder.toString();
        }
    }

    @Override
    public String name() {
        return "设置查询表语句片段";
    }

}
