package cn.schoolwow.quickdao.flow.dql.condition.get;

import cn.schoolwow.quickdao.dao.dql.condition.ConditionImpl;
import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickdao.flow.dql.condition.common.SetJoinTableIndexFlow;
import cn.schoolwow.quickdao.flow.dql.condition.set.SetFromTableFragmentFlow;
import cn.schoolwow.quickdao.flow.dql.condition.set.SetJoinTableFragmentFlow;
import cn.schoolwow.quickdao.flow.dql.condition.set.SetQueryColumnListFlow;
import cn.schoolwow.quickdao.flow.dql.condition.set.SetQueryFragmentFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.ArrayList;
import java.util.List;

public class GetFromConditionStatement implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setFromQueryContext(flowContext);
        setFromConditionStatement(flowContext);
        setFromConditionParameter(flowContext);
    }

    @Override
    public String name() {
        return "获取fromCondition的SQL语句";
    }

    private void setFromQueryContext(FlowContext flowContext){
        ConditionImpl fromCondition = (ConditionImpl) flowContext.checkData("fromCondition");

        QueryContext fromQueryContext = new QueryContext();
        fromQueryContext.queryOption = fromCondition.queryOption;
        flowContext.getQuickFlow().startFlow("获取FromCondition的SQL语句")
                .putTemporaryData("queryContext", fromQueryContext)
                .putTemporaryData("addColumnAliasName", false)
                .putTemporaryData("addTableAliasName", true)
                .next(new SetJoinTableIndexFlow())
                .next(new SetQueryColumnListFlow())
                .next(new SetFromTableFragmentFlow())
                .next(new SetJoinTableFragmentFlow())
                .next(new SetQueryFragmentFlow())
                .execute();
        flowContext.putTemporaryData("fromQueryContext", fromQueryContext);
    }

    private void setFromConditionStatement(FlowContext flowContext){
        QueryContext fromQueryContext = (QueryContext) flowContext.checkData("fromQueryContext");

        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(fromQueryContext.select
                + fromQueryContext.from
                + fromQueryContext.join
                + fromQueryContext.where
                + fromQueryContext.groupBy
                + fromQueryContext.having
                + fromQueryContext.orderBy
        );
        flowContext.putData("fromConditionStatement", sqlBuilder.toString());
    }

    private void setFromConditionParameter(FlowContext flowContext){
        ConditionImpl fromCondition = (ConditionImpl) flowContext.checkData("fromCondition");
        List<Object> fromConditionParameters = new ArrayList<>();

        fromConditionParameters.addAll(fromCondition.queryOption.queryFragmentOption.whereParameterList);
        fromConditionParameters.addAll(fromCondition.queryOption.queryFragmentOption.havingParameterList);

        flowContext.putData("fromConditionParameters", fromConditionParameters);
    }
}
