package cn.schoolwow.quickdao.flow.dml.json.save;

import cn.schoolwow.quickdao.flow.dml.json.common.check.CheckUniqueFieldNameFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.InsertJSONObjectFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.get.GetCountByUniqueFieldFlow;
import cn.schoolwow.quickdao.flow.dml.json.update.UpdateJSONObjectFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SaveJSONObjectFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(
                new CheckUniqueFieldNameFlow(),
                new GetCountByUniqueFieldFlow()
        );

        Long count = (Long) flowContext.getData("count");
        if(null==count||count==0){
            flowContext.executeFlowList(new InsertJSONObjectFlow());
        }else{
            flowContext.executeFlowList(new UpdateJSONObjectFlow());
        }
    }

    @Override
    public String name() {
        return "保存JSONObject";
    }
}
