package cn.schoolwow.quickdao.flow.dml.json.insert.get;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class GetUniqueFieldValueListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setStatement(flowContext);
        JSONArray instances = (JSONArray) flowContext.checkData("instances");
        for(int i=0;i<instances.size();i++){
            flowContext.putTemporaryData("instance", instances.getJSONObject(i));
            setParameters(flowContext);
            executeStatement(flowContext);
            flowContext.removeData("instance");
        }
    }

    @Override
    public String name() {
        return "根据多个唯一字段查询记录字段值";
    }

    private void setStatement(FlowContext flowContext){
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        String tableName = (String) flowContext.checkData("tableName");
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");

        StringBuilder sqlBuilder = new StringBuilder("select");
        for(String uniqueFieldName:manipulationOption.uniqueFieldNames){
            sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.escape(uniqueFieldName) + ",");
        }
        sqlBuilder.deleteCharAt(sqlBuilder.length()-1);
        sqlBuilder.append(" from " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + " where");
        for(String uniqueFieldName:manipulationOption.uniqueFieldNames){
            sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.escape(uniqueFieldName) + " = ? and");
        }
        sqlBuilder.delete(sqlBuilder.length()-4,sqlBuilder.length());
        flowContext.putTemporaryData("sql", sqlBuilder.toString());
    }

    private void setParameters(FlowContext flowContext){
        JSONObject instance = (JSONObject) flowContext.checkData("instance");
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");

        List<Object> parameters = new ArrayList();
        for(String uniqueFieldName:manipulationOption.uniqueFieldNames){
            parameters.add(instance.get(uniqueFieldName));
        }
        flowContext.putTemporaryData("parameters", parameters);
    }

    private void executeStatement(FlowContext flowContext){
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");

        List<String> uniqueFieldValueList = new ArrayList<>();
        StringBuilder uniqueFieldNameValueBuilder = new StringBuilder();
        flowContext.startFlow(new ExecuteQueryConnectionFlow())
                .putTemporaryData("name", "根据多个唯一字段查询记录字段值")
                .putTemporaryData("resultSetConsumer", new ResultSetConsumer() {
                    @Override
                    public void consumeResultSet(ResultSet resultSet) throws Exception {
                        while(resultSet.next()){
                            uniqueFieldNameValueBuilder.setLength(0);
                            for(String uniqueFieldName:manipulationOption.uniqueFieldNames){
                                uniqueFieldNameValueBuilder.append(resultSet.getString(uniqueFieldName)+"|");
                            }
                            uniqueFieldValueList.add(uniqueFieldNameValueBuilder.toString());
                        }
                        flowContext.putTemporaryData("uniqueFieldValueList", uniqueFieldValueList);
                    }
                })
                .execute();
    }
}
