package cn.schoolwow.quickdao.flow.dml.json.insert.get;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class GetSingleColumnValueListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setStatement(flowContext);
        setParameters(flowContext);
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "根据单个字段查询记录字段值";
    }

    private void setStatement(FlowContext flowContext){
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        String tableName = (String) flowContext.checkData("tableName");
        String singleColumnName = (String) flowContext.checkData("singleColumnName");
        JSONArray instances = (JSONArray) flowContext.checkData("instances");

        StringBuilder sqlBuilder = new StringBuilder("select " + quickDAOConfig.databaseContext.databaseProvider.escape(singleColumnName));
        sqlBuilder.append(" from " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName));
        sqlBuilder.append(" where " + quickDAOConfig.databaseContext.databaseProvider.escape(singleColumnName) + " in (");
        for(int i=0;i<instances.size();i++){
            sqlBuilder.append("?,");
        }
        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        sqlBuilder.append(")");
        flowContext.putTemporaryData("sql", sqlBuilder.toString());
    }

    private void setParameters(FlowContext flowContext){
        String tableName = (String) flowContext.checkData("tableName");
        String singleColumnName = (String) flowContext.checkData("singleColumnName");
        JSONArray instances = (JSONArray) flowContext.checkData("instances");

        List<Object> parameters = new ArrayList();
        for(int i=0;i<instances.size();i++){
            JSONObject instance = instances.getJSONObject(i);
            Object value = instance.get(singleColumnName);
            if(null==value){
                throw new IllegalArgumentException("执行逻辑异常!实例指定字段值不能为空!表名:"+tableName+",字段值:"+singleColumnName);
            }
            parameters.add(value);
        }
        flowContext.putTemporaryData("parameters", parameters);
    }

    private void executeStatement(FlowContext flowContext){
        String singleColumnName = (String) flowContext.checkData("singleColumnName");

        List<String> singleColumnValueList = new ArrayList<>();
        flowContext.startFlow(new ExecuteQueryConnectionFlow())
                .putTemporaryData("name", "根据单个字段获取记录值")
                .putTemporaryData("resultSetConsumer", new ResultSetConsumer() {
                    @Override
                    public void consumeResultSet(ResultSet resultSet) throws Exception {
                        while(resultSet.next()){
                            singleColumnValueList.add(resultSet.getString(singleColumnName));
                        }
                        flowContext.putTemporaryData("singleColumnValueList", singleColumnValueList);
                    }
                })
                .execute();
    }
}
