package cn.schoolwow.quickdao.flow.dml.json.insert.common;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class SetInsertJSONObjectParameterFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        List<String> columnNameList = (List<String>) flowContext.checkData("columnNameList");
        JSONObject instance = (JSONObject) flowContext.checkData("instance");

        List<Object> parameters = new ArrayList<Object>();
        for(String columnName:columnNameList){
            Object value = instance.get(columnName);
            parameters.add(value);
        }
        flowContext.putTemporaryData("parameters", parameters);
    }

    @Override
    public String name() {
        return "设置插入JSONObject参数列表";
    }

}
