package cn.schoolwow.quickdao.flow.dml.json.delete;

import cn.schoolwow.quickdao.flow.dml.json.common.check.CheckUniqueFieldNameFlow;
import cn.schoolwow.quickdao.flow.dml.json.delete.common.SetDeleteJSONObjectParameterFlow;
import cn.schoolwow.quickdao.flow.dml.json.delete.common.SetDeleteJSONObjectStatementFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class DeleteJSONObjectFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(
                new CheckUniqueFieldNameFlow(),
                new SetDeleteJSONObjectStatementFlow(),
                new SetDeleteJSONObjectParameterFlow()
        );
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "删除JSONObject";
    }

    private void executeStatement(FlowContext flowContext) {
        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "删除JSONObject")
                .execute();
    }
}
