package cn.schoolwow.quickdao.flow.dml.json.delete;

import cn.schoolwow.quickdao.domain.internal.dml.GetBatchParametersSupplier;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.dml.json.delete.common.DeleteBySingleUniqueFieldFlow;
import cn.schoolwow.quickdao.flow.dml.json.delete.common.SetDeleteJSONObjectParameterFlow;
import cn.schoolwow.quickdao.flow.dml.json.insert.common.SetInsertJSONObjectStatementFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteBatchUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

public class DeleteJSONArrayFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new SetInsertJSONObjectStatementFlow());
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        if(manipulationOption.uniqueFieldNames.size()==1){
            deleteBySingleUniqueField(flowContext);
        }else{
            deleteByMultipleUniqueField(flowContext);
        }
    }

    @Override
    public String name() {
        return "删除JSONArray";
    }

    private void deleteBySingleUniqueField(FlowContext flowContext){
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        String singleUniqueFieldName = manipulationOption.uniqueFieldNames.iterator().next();
        flowContext.putTemporaryData("singleUniqueFieldName", singleUniqueFieldName);
        flowContext.executeFlowList(new DeleteBySingleUniqueFieldFlow());
    }

    private void deleteByMultipleUniqueField(FlowContext flowContext){
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        JSONArray instances = (JSONArray) flowContext.checkData("instances");

        flowContext.startFlow(new ExecuteBatchUpdateConnectionFlow())
                .putTemporaryData("perBatchCount", manipulationOption.perBatchCount)
                .putTemporaryData("name", "批处理删除JSONArray")
                .putTemporaryData("size", instances.size())
                .putTemporaryData("getBatchParametersSupplier", new GetBatchParametersSupplier() {
                    @Override
                    public List<Object> getBatchParameters(Integer index) throws Exception {
                        JSONObject instance = instances.getJSONObject(index);
                        flowContext.putTemporaryData("instance", instance);
                        flowContext.executeFlowList(new SetDeleteJSONObjectParameterFlow());
                        List<Object> parameters = (List<Object>) flowContext.checkData("parameters");
                        return parameters;
                    }
                })
                .execute();
    }

}
