package cn.schoolwow.quickdao.flow.dml.json.common.filter;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.dml.CheckStrategy;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.*;

public class FilterJSONArrayBySameUniqueFieldFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        shouldCheck(flowContext);
        filterJSONArrayBySameUniqueField(flowContext);
    }

    @Override
    public String name() {
        return "过滤唯一约束字段值相同的JSONObject";
    }

    private void shouldCheck(FlowContext flowContext){
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        CheckStrategy checkStrategy = null!=manipulationOption.checkStrategy?manipulationOption.checkStrategy:quickDAOConfig.databaseOption.checkStrategy;
        if(CheckStrategy.None.equals(checkStrategy)){
            flowContext.brokenCurrentFlow("根据字段约束策略,跳过过滤唯一约束字段值相同的JSONObject");
        }
        if(manipulationOption.uniqueFieldNames.isEmpty()){
            flowContext.brokenCurrentFlow("用户未指定唯一性约束字段,跳过过滤唯一约束字段值相同的JSONObject");
        }
    }

    private void filterJSONArrayBySameUniqueField(FlowContext flowContext){
        JSONArray instances = (JSONArray) flowContext.checkData("instances");
        ManipulationOption manipulationOption = (ManipulationOption) flowContext.checkData("manipulationOption");
        Map<JSONObject,String> instanceReasonMap = (Map<JSONObject, String>) flowContext.getData("instanceReasonMap", new LinkedHashMap<String,Object>());

        Set<String> uniqueFieldValueSet = new HashSet<>();
        StringBuilder uniqueFieldValueBuilder = new StringBuilder();
        JSONArray filterInstances = new JSONArray();
        filterInstances.addAll(instances);
        Iterator<Object> iterator = filterInstances.iterator();
        while(iterator.hasNext()){
            JSONObject instance = (JSONObject) iterator.next();
            uniqueFieldValueBuilder.setLength(0);
            for(String uniqueFieldName:manipulationOption.uniqueFieldNames){
                uniqueFieldValueBuilder.append(instance.getString(uniqueFieldName)+"|");
            }
            String uniqueFieldValue = uniqueFieldValueBuilder.toString();
            if(uniqueFieldValueSet.contains(uniqueFieldValue)){
                String reason = "存在相同唯一约束实例!唯一约束:"+uniqueFieldValue;
                if(!instanceReasonMap.containsKey(instance)){
                    instanceReasonMap.put(instance, reason);
                }else{
                    String oldReason = instanceReasonMap.get(instance);
                    instanceReasonMap.put(instance, oldReason+";"+reason);
                }
                iterator.remove();
                continue;
            }
            uniqueFieldValueSet.add(uniqueFieldValue);
        }
        if(filterInstances.isEmpty()){
            flowContext.putData("effect", 0);
            flowContext.broken("根据唯一约束字段约束过滤数据后实例列表为空");
        }
        flowContext.putData("instances", filterInstances);
    }
}
