package cn.schoolwow.quickdao.flow.dml.instance.insert.get;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class GetSinglePropertyValueListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setStatement(flowContext);
        setParameters(flowContext);
        executeStatement(flowContext);
    }

    @Override
    public String name() {
        return "根据单个字段获取记录值";
    }

    private void setStatement(FlowContext flowContext){
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity) flowContext.checkData("entity");
        Property singleProperty = (Property) flowContext.checkData("singleProperty");
        Object[] instances = (Object[]) flowContext.checkData("instances");

        StringBuilder sqlBuilder = new StringBuilder("select " + quickDAOConfig.databaseContext.databaseProvider.escape(singleProperty.column));
        sqlBuilder.append(" from " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName));
        sqlBuilder.append(" where " + quickDAOConfig.databaseContext.databaseProvider.escape(singleProperty.column) + " in (");
        for(int i=0;i<instances.length;i++){
            sqlBuilder.append("?,");
        }
        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        sqlBuilder.append(")");
        flowContext.putTemporaryData("sql", sqlBuilder.toString());
    }

    private void setParameters(FlowContext flowContext){
        Property singleProperty = (Property) flowContext.checkData("singleProperty");
        Object[] instances = (Object[]) flowContext.checkData("instances");

        List<Object> parameters = new ArrayList();
        for(Object instance:instances){
            Object value = ParametersUtil.getFieldValueFromInstance(instance, singleProperty.name);
            if(null!=value){
                parameters.add(value);
            }
        }
        flowContext.putTemporaryData("parameters", parameters);
    }

    private void executeStatement(FlowContext flowContext){
        Property singleProperty = (Property) flowContext.checkData("singleProperty");
        
        List<String> singlePropertyValueList = new ArrayList<>();
        flowContext.startFlow(new ExecuteQueryConnectionFlow())
                .putTemporaryData("name", "根据单个字段获取记录值")
                .putTemporaryData("resultSetConsumer", new ResultSetConsumer() {
                    @Override
                    public void consumeResultSet(ResultSet resultSet) throws Exception {
                        while(resultSet.next()){
                            singlePropertyValueList.add(resultSet.getString(singleProperty.column));
                        }
                        flowContext.putTemporaryData("singlePropertyValueList", singlePropertyValueList);
                    }
                })
                .execute();
    }

}
