package cn.schoolwow.quickdao.flow.dml.instance.insert;

import cn.schoolwow.quickdao.flow.dml.instance.common.SetGenerateKeysFlow;
import cn.schoolwow.quickdao.flow.dml.instance.common.SetInstanceEntityFlow;
import cn.schoolwow.quickdao.flow.dml.instance.insert.common.SetInsertInstanceParameterFlow;
import cn.schoolwow.quickdao.flow.dml.instance.insert.common.SetInsertInstanceStatementFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class InsertInstanceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.putTemporaryData("name", "插入实例");
        flowContext.executeFlowList(
                new SetInstanceEntityFlow(),
                new SetInsertInstanceStatementFlow(),
                new SetInsertInstanceParameterFlow(),
                new ExecuteUpdateConnectionFlow(),
                new SetGenerateKeysFlow()
        );
    }

    @Override
    public String name() {
        return "插入实例";
    }

}
