package cn.schoolwow.quickdao.flow.dml.instance.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SetInstanceEntityFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        Object instance = flowContext.getData("instance");
        if(null==instance){
            Object[] instances = (Object[]) flowContext.checkData("instances");
            instance = instances[0];
        }
        Entity entity = quickDAOConfig.getEntityByClassName(instance.getClass().getName());
        if(null==entity){
            throw new IllegalArgumentException("根据实例类名获取实体类信息失败!实例类名:"+instance.getClass().getName());
        }
        flowContext.putData("entity", entity);
        flowContext.remark("实例表名:"+entity.tableName+",类名:"+entity.clazz.getSimpleName());
    }

    @Override
    public String name() {
        return "设置实例Entity信息";
    }
}
