package cn.schoolwow.quickdao.flow.ddl.table;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class RenameTableFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        String oldTableName = (String) flowContext.checkData("oldTableName");
        String newTableName = (String) flowContext.checkData("newTableName");

        oldTableName = StringUtil.camel2Underline(oldTableName);
        newTableName = StringUtil.camel2Underline(newTableName);

        flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                .putTemporaryData("name", "重命名表")
                .putTemporaryData("sql", "rename table " + quickDAOConfig.databaseContext.databaseProvider.escape(oldTableName) + " to " + quickDAOConfig.databaseContext.databaseProvider.escape(newTableName) + ";")
                .execute();
    }

    @Override
    public String name() {
        return "重命名表";
    }

}
