package cn.schoolwow.quickdao.flow.ddl.table;

import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class GetTableNameListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");

        flowContext.putTemporaryData("name", "获取数据库表名列表");
        switch (databaseType){
            case H2:{
                flowContext.putTemporaryData("sql", "show tables;");
                flowContext.putTemporaryData("tableNameColumn", "TABLE_NAME");
            }break;
            case SQLite:{
                flowContext.putTemporaryData("sql", "select name from sqlite_master where type='table' and name != 'sqlite_sequence';");
                flowContext.putTemporaryData("tableNameColumn", "name");
            }break;
            case Mysql:
            case MariaDB:{
                flowContext.putTemporaryData("sql", "show table status;");
                flowContext.putTemporaryData("tableNameColumn", "name");
            }break;
            case Postgresql:{
                flowContext.putTemporaryData("sql", "select relname as name from pg_class c where relkind = 'r' and relname not like 'pg_%' and relname not like 'sql_%' order by relname;");
                flowContext.putTemporaryData("tableNameColumn", "name");
            }break;
            case SQLServer:{
                flowContext.putTemporaryData("sql", "select name from sysobjects where xtype='u' order by name;");
                flowContext.putTemporaryData("tableNameColumn", "name");
            }break;
            case Oracle:{
                flowContext.putTemporaryData("sql", "select user_tables.table_name from user_tables");
                flowContext.putTemporaryData("tableNameColumn", "table_name");
            }break;
        }

        flowContext.startFlow(new ExecuteQueryConnectionFlow())
                .putTemporaryData("resultSetConsumer", new ResultSetConsumer() {
                    @Override
                    public void consumeResultSet(ResultSet resultSet) throws Exception {
                        List<String> tableNameList = new ArrayList<>();
                        String tableNameColumn = (String) flowContext.checkData("tableNameColumn");
                        while(resultSet.next()){
                            tableNameList.add(resultSet.getString(tableNameColumn));
                        }
                        flowContext.putData("tableNameList", tableNameList);
                    }
                })
                .execute();
    }

    @Override
    public String name() {
        return "获取数据库表名列表";
    }
}
