package cn.schoolwow.quickdao.flow.ddl.table;

import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class EnableForeignConstraintCheckFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType) flowContext.checkData("databaseType");
        boolean enable = (boolean) flowContext.checkData("enable");
        switch (databaseType){
            case SQLite:{
                flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                        .putTemporaryData("name", enable ? "启用外键约束检查" : "禁用外键约束检查")
                        .putTemporaryData("sql", "PRAGMA foreign_keys = " + enable + ";")
                        .execute();
            }break;
            case Mysql:
            case MariaDB:{
                flowContext.startFlow(new ExecuteUpdateConnectionFlow())
                        .putTemporaryData("name", enable ? "启用外键约束检查" : "禁用外键约束检查")
                        .putTemporaryData("sql", "set foreign_key_checks = " + (enable ? 1 : 0) + ";")
                        .execute();
            }break;
            default:{
                flowContext.broken("当前数据库不支持开启/关闭外键约束!");
            }
        }
    }

    @Override
    public String name() {
        return "开启外键约束检查";
    }
}
