package cn.schoolwow.quickdao.flow.ddl.has;

import cn.schoolwow.quickdao.flow.ddl.has.common.SetHasResultSetFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.Arrays;

public class HasConstraintFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String constraintName = (String) flowContext.checkData("constraintName");

        flowContext.startFlow(new ExecuteQueryConnectionFlow())
                .next(new SetHasResultSetFlow())
                .putTemporaryData("name", "判断约束是否存在")
                .putTemporaryData("sql", "select constraint_name from information_schema.KEY_COLUMN_USAGE where constraint_name = ?;")
                .putTemporaryData("parameters", Arrays.asList(constraintName))
                .execute();
    }

    @Override
    public String name() {
        return "约束是否存在";
    }
}
