package cn.schoolwow.quickdao.flow.ddl.createTable;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.flow.ddl.common.GetAutoIncrementStatementFlow;
import cn.schoolwow.quickdao.flow.ddl.createTable.common.BuildForeignKeyFlow;
import cn.schoolwow.quickdao.flow.ddl.createTable.common.BuildIndexFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SQLServerCreateTableFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        buildColumn(flowContext);
        flowContext.executeFlowList(new BuildForeignKeyFlow());
        buildTableComment(flowContext);
        flowContext.executeFlowList(new BuildIndexFlow());
        buildComment(flowContext);
    }

    @Override
    public String name() {
        return "Postgres数据库创建表";
    }

    private void buildColumn(FlowContext flowContext) throws Exception {
        Entity entity = (Entity) flowContext.checkData("entity");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");

        StringBuilder sqlBuilder = new StringBuilder("create table " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + "(");
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                flowContext.startFlow(new GetAutoIncrementStatementFlow())
                        .putTemporaryData("propertyOption", property)
                        .execute();
            } else {
                sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.range ? "" : "(" + property.range + ")"));
                if (null!=property.notNull&&property.notNull) {
                    sqlBuilder.append(" not null");
                }
                if (null != property.defaultValue) {
                    sqlBuilder.append(" default '" + property.defaultValue + "'");
                }
                if (null != property.comment) {
                    sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(property.comment));
                }
                if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                    sqlBuilder.append(" check " + property.escapeCheck);
                }
            }
            sqlBuilder.append(",");
        }
        flowContext.putTemporaryData("sqlBuilder", sqlBuilder);
    }

    private void buildTableComment(FlowContext flowContext){
        StringBuilder sqlBuilder = (StringBuilder) flowContext.checkData("sqlBuilder");
        sqlBuilder.append(");");
    }

    private void buildComment(FlowContext flowContext){
        StringBuilder sqlBuilder = (StringBuilder) flowContext.checkData("sqlBuilder");
        Entity entity = (Entity) flowContext.checkData("entity");

        //添加注释
        if (null != entity.comment) {
            sqlBuilder.append("EXEC sp_addextendedproperty 'MS_Description',N'" + entity.comment + "','SCHEMA','dbo','table',N'" + entity.tableName + "';");
        }
        for (Property property : entity.properties) {
            if (null != property.comment) {
                sqlBuilder.append("EXEC sp_addextendedproperty 'MS_Description',N'" + property.comment + "','SCHEMA','dbo','table',N'" + entity.tableName + "','column',N'" + property.column + "';");
            }
        }
    }
}
