package cn.schoolwow.quickdao.flow.ddl.common;

import cn.schoolwow.quickdao.domain.external.PropertyOption;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class GetEscapeCheckFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        PropertyOption propertyOption = (PropertyOption) flowContext.checkData("propertyOption");
        if (null != propertyOption.check) {
            if (!propertyOption.check.isEmpty() && !propertyOption.check.contains("(")) {
                propertyOption.check = "(" + propertyOption.check + ")";
            }
            propertyOption.check = propertyOption.check.replace("#{" + propertyOption.name + "}", propertyOption.column);

            String escapeCheck = propertyOption.check.replace(propertyOption.column, quickDAOConfig.databaseContext.databaseProvider.escape(propertyOption.column));;
            flowContext.putTemporaryData("escapeCheck", escapeCheck);
        }
    }

    @Override
    public String name() {
        return "获取转义后的check约束";
    }
}
