package cn.schoolwow.quickdao.flow.common;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.GetStatementSupplier;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class GetAndCacheStatementFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig) flowContext.checkData("quickDAOConfig");
        String sqlCacheName = (String) flowContext.useData("sqlCacheName");

        if(quickDAOConfig.databaseContext.statementCache.contains(sqlCacheName)){
            flowContext.putData("sql", quickDAOConfig.databaseContext.statementCache.get(sqlCacheName));
        }else{
            GetStatementSupplier getStatementSupplier = (GetStatementSupplier) flowContext.useData("getStatementSupplier");
            String sql = getStatementSupplier.getStatement();
            quickDAOConfig.databaseContext.statementCache.put(sqlCacheName, sql);
            flowContext.putData("sql", sql);
        }
    }

    @Override
    public String name() {
        return "获取并缓存SQL语句";
    }
}
