package cn.schoolwow.quickdao.domain.internal.config;

import cn.schoolwow.quickdao.domain.external.entity.SqlLog;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class LogRecordOption {
    /**
     * 是否记录SQL日志到数据库
     */
    public boolean recordSqlLog;

    /**
     * 是否打印流程日志
     * */
    public boolean recordFlowLog;

    /**
     * 是否开启记录模式
     * */
    public boolean record;

    /**
     * 记录SQL语句
     * */
    public StringBuffer sqlRecordBuilder = new StringBuffer();

    /**
     * 线程绑定日志对象,类名和对应日志实例(支持以key作为唯一值)
     * */
    public ThreadLocal<Map<String, Map<String,Object>>> classNameLogInstanceMapThreadLocal = new ThreadLocal<>();

    /**
     * SQL日志队列
     * */
    public BlockingQueue<SqlLog> sqlLogBlockingQueue = new ArrayBlockingQueue<SqlLog>(1024);
}
