package cn.schoolwow.quickdao.dao;

import cn.schoolwow.quickdao.dao.dcl.DatabaseControl;
import cn.schoolwow.quickdao.dao.dcl.DatabaseControlImpl;
import cn.schoolwow.quickdao.dao.ddl.DatabaseDefinition;
import cn.schoolwow.quickdao.dao.ddl.DatabaseDefinitionImpl;
import cn.schoolwow.quickdao.dao.dml.DatabaseManipulationImpl;
import cn.schoolwow.quickdao.dao.dql.DatabaseQuery;
import cn.schoolwow.quickdao.dao.dql.DatabaseQueryImpl;
import cn.schoolwow.quickdao.dao.operation.DAOOperation;
import cn.schoolwow.quickdao.dao.operation.DAOOperationImpl;
import cn.schoolwow.quickdao.dao.query.QueryOperation;
import cn.schoolwow.quickdao.dao.query.QueryOperationImpl;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickflow.QuickFlow;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

/**
 * DAO接口调用代理模式对象
 */
public class DAOInvocationHandler implements InvocationHandler {
    private DatabaseControl databaseControl;
    private DatabaseDefinition databaseDefinition;
    private DatabaseQuery databaseQuery;
    private QueryOperation queryOperation;
    private DAOOperation daoOperation;
    private QuickFlow quickFlow;
    private QuickDAOConfig quickDAOConfig;

    public DAOInvocationHandler(QuickFlow quickFlow, QuickDAOConfig quickDAOConfig) {
        this.quickFlow = quickFlow;
        this.quickDAOConfig = quickDAOConfig;
        databaseControl = new DatabaseControlImpl(quickFlow, quickDAOConfig);
        databaseDefinition = new DatabaseDefinitionImpl(quickFlow, quickDAOConfig);
        databaseQuery = new DatabaseQueryImpl(quickFlow, quickDAOConfig);
        queryOperation = new QueryOperationImpl(quickFlow, quickDAOConfig);
        daoOperation = new DAOOperationImpl(quickDAOConfig);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String interfaceName = method.getDeclaringClass().getSimpleName();
        Object result = null;
        switch (interfaceName) {
            case "DatabaseControl": {
                result = method.invoke(databaseControl, args);
            }
            break;
            case "DatabaseDefinition": {
                result = method.invoke(databaseDefinition, args);
            }
            break;
            case "DatabaseManipulation": {
                result = method.invoke(new DatabaseManipulationImpl(quickFlow, quickDAOConfig), args);
            }
            break;
            case "DatabaseQuery": {
                result = method.invoke(databaseQuery, args);
            }
            break;
            case "QueryOperation":{
                result = method.invoke(queryOperation, args);
            }break;
            case "DAOOperation":{
                result = method.invoke(daoOperation, args);
            }break;
            default: {
                throw new IllegalAccessError("不支持调用该方法!方法名:"+method.getName());
            }
        }
        return result;
    }
}
