package cn.schoolwow.quickdao.statement.dml.instance;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;

/**更新记录*/
public class UpdateInstanceDatabaseStatement extends AbstractDMLInstanceDatabaseStatement {
    /**实例列表*/
    private Object[] instances;

    public UpdateInstanceDatabaseStatement(Object[] instances, ManipulationOption option, QuickDAOConfig quickDAOConfig) {
        super(option, quickDAOConfig);
        this.instances = instances;
    }

    @Override
    public int executeUpdate(){
        Entity entity = quickDAOConfig.getEntityByClassName(instances[0].getClass().getName());
        //指定实体类既无id又无唯一性约束
        if(entity.uniqueProperties.isEmpty()&&null==entity.id) {
            throw new UnsupportedOperationException("指定实体类既无id又无唯一性约束!无法进行更新操作!!实体类:"+entity.clazz.getName());
        }
        //未指定更新类型且指定实体类既有id又有唯一性约束
        if(null==option.updateType&&!entity.uniqueProperties.isEmpty()&&null!=entity.id) {
            throw new UnsupportedOperationException("指定实体类既有id又有唯一性约束!请调用updateType方法指定更新类型!实体类:"+entity.clazz.getName());
        }

        option.returnGeneratedKeys = false;
        if(null!=option.updateType){
            switch (option.updateType){
                case UpdateById:{return new UpdateInstanceByIdDatabaseStatement(instances, option, quickDAOConfig).executeUpdate();}
                case UpdateByUniqueKey:{return new UpdateInstanceByUniqueKeyDatabaseStatement(instances, option, quickDAOConfig).executeUpdate();}
            }
            throw new UnsupportedOperationException("不支持的UpdateType!updateType:"+option.updateType);
        }else{
            if (!entity.uniqueProperties.isEmpty()) {
                //根据唯一性约束更新
                return new UpdateInstanceByUniqueKeyDatabaseStatement(instances, option, quickDAOConfig).executeUpdate();
            } else {
                //根据id更新
                return new UpdateInstanceByIdDatabaseStatement(instances, option, quickDAOConfig).executeUpdate();
            }
        }
    }
}
