package cn.schoolwow.quickdao.dao;

import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.dao.transaction.Transaction;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.provider.DatabaseProvider;

import javax.sql.DataSource;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public interface DAOOperation {
    /**
     * 数据库查询语句
     *
     * @param clazz 实体类表
     */
    <T> Condition<T> query(Class<T> clazz);

    /**
     * 数据库查询语句
     *
     * @param tableName 指定表名
     */
    Condition query(String tableName);

    /**
     * 数据库查询语句
     *
     * @param condition 子查询
     */
    Condition query(Condition condition);

    /**
     * 获取当前线程绑定事务
     */
    Transaction getThreadTransaction();

    /**
     * 开启事务
     */
    Transaction startTransaction();

    /**
     * 开启事务
     */
    void startTransaction(Consumer<Transaction> transactionConsumer);

    /**
     * 获取连接池
     */
    DataSource getDataSource();

    /**
     * 获取扫描的所有实体类信息
     */
    Map<String, Entity> getEntityMap();

    /**
     * 获取实体类表
     *
     * @param clazz 实体类
     */
    Entity getEntity(Class clazz);

    /**
     * 获取实体类表
     *
     * @param tableName 数据库表名
     */
    Entity getEntity(String tableName);

    /**
     * 获取数据库提供者
     */
    DatabaseProvider getDatabaseProvider();

    /**
     * 获取配置信息
     */
    QuickDAOConfig getQuickDAOConfig();

    /**
     * 开启记录模式,只记录SQL语句,不执行
     * */
    void startRecord();

    /**
     * 停止记录模式
     * @return 返回记录SQL语句
     * */
    String stopRecord();

    /**
     * 线程绑定日志记录
     * @param logEntity 日志实例类
     * */
    <T> T log(Class<T> logEntity);

    /**
     * 线程绑定日志实例记录,存在则返回,不存在返回null
     * @param uniqueKey 日志实例唯一值
     * @param logEntity 日志实例类
     * */
    <T> T logMapIfExist(String uniqueKey, Class<T> logEntity);

    /**
     * 线程绑定多个日志实例记录
     * @param logEntity 日志实例类
     * */
    <T> List<T> logMap(Class<T> logEntity);

    /**
     * 线程绑定多个日志实例记录
     * @param uniqueKey 日志实例唯一值
     * @param logEntity 日志实例类
     * */
    <T> T logMap(String uniqueKey, Class<T> logEntity);

    /**
     * 插入线程绑定日志记录
     * */
    void insertLog();
}
