/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.util;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseUtil {
    private static Logger logger = LoggerFactory.getLogger(DatabaseUtil.class);

    public static void automaticCreateTable(QuickDAOConfig quickDAOConfig) {
        Collection<Entity> entityList = quickDAOConfig.entityMap.values();
        for (Entity entity : entityList) {
            Entity databaseEntity = quickDAOConfig.getDatabaseEntityByTableName(entity.tableName);
            logger.trace("\u81ea\u52a8\u521b\u5efa\u8868,\u6570\u636e\u5e93\u8868\u540d:{}, \u5b9e\u4f53\u7c7b\u540d:{}", (Object)entity.tableName, (Object)entity.clazz.getName());
            if (null != databaseEntity) continue;
            quickDAOConfig.dao.create(entity);
        }
    }

    public static void automaticCreateProperty(QuickDAOConfig quickDAOConfig) {
        Collection<Entity> entityList = quickDAOConfig.entityMap.values();
        for (Entity entity : entityList) {
            Entity databaseEntity = quickDAOConfig.getDatabaseEntityByTableName(entity.tableName);
            List<Property> sourcePropertyList = entity.properties;
            for (Property sourceProperty : sourcePropertyList) {
                Property targetProperty = databaseEntity.getPropertyByFieldName(sourceProperty.column);
                if (null == targetProperty) {
                    logger.trace("\u81ea\u52a8\u521b\u5efa\u8868\u5b57\u6bb5,\u8868\u540d:{},\u5b57\u6bb5\u540d:{}", (Object)databaseEntity.tableName, (Object)sourceProperty.column);
                    quickDAOConfig.dao.createColumn(databaseEntity.tableName, sourceProperty);
                }
                if (null == sourceProperty.foreignKey || !quickDAOConfig.databaseOption.openForeignKey) continue;
                logger.trace("\u81ea\u52a8\u521b\u5efa\u8868\u5916\u952e,\u8868\u540d:{},\u5b57\u6bb5\u540d:{}", (Object)sourceProperty.entity.tableName, (Object)sourceProperty.column);
                quickDAOConfig.dao.createForeignKey(sourceProperty);
            }
            for (IndexField indexField : entity.indexFieldList) {
                if (null != databaseEntity.getIndexFieldByIndexName(indexField.indexName)) continue;
                quickDAOConfig.dao.createIndex(indexField);
            }
        }
    }

    public static void automaticDeleteTableAndProperty(DAO dao) {
        Map<String, Entity> entityMap = dao.getEntityMap();
        if (null == entityMap || entityMap.isEmpty()) {
            logger.warn("\u672a\u626b\u63cf\u5230\u4efb\u4f55\u5b9e\u4f53\u7c7b!\u8bf7\u8bbe\u7f6e\u5305\u8def\u5f84\u6216\u8005\u5b9e\u4f53\u7c7b!");
            return;
        }
        Collection<Entity> entityList = entityMap.values();
        List<Entity> databaseEntityList = dao.getDatabaseEntityList();
        ArrayList<String> dropTableNameList = new ArrayList<String>();
        ArrayList<Property> dropPropertyList = new ArrayList<Property>();
        for (Entity databaseEntity : databaseEntityList) {
            Entity sourceEntity = null;
            for (Entity entityItem : entityList) {
                if (!databaseEntity.tableName.equalsIgnoreCase(entityItem.tableName)) continue;
                sourceEntity = entityItem;
                break;
            }
            if (null == sourceEntity) {
                dropTableNameList.add(databaseEntity.tableName);
                continue;
            }
            for (Property dbProperty : databaseEntity.properties) {
                Property sourceEntityProperty = null;
                for (Property propertyItem : sourceEntity.properties) {
                    if (!dbProperty.column.equalsIgnoreCase(propertyItem.column)) continue;
                    sourceEntityProperty = propertyItem;
                    break;
                }
                if (null != sourceEntityProperty) continue;
                dropPropertyList.add(dbProperty);
            }
        }
        for (String dropTableName : dropTableNameList) {
            logger.info("\u540c\u6b65\u5b9e\u4f53\u7c7b,\u5220\u9664\u8868:{}", (Object)dropTableName);
            dao.dropTable(dropTableName);
        }
        for (Property dropProperty : dropPropertyList) {
            logger.info("\u540c\u6b65\u5b9e\u4f53\u7c7b,\u5220\u9664\u8868\u5b57\u6bb5.\u8868\u540d:{},\u5b57\u6bb5\u540d:{}", (Object)dropProperty.entity.tableName, (Object)dropProperty.column);
            dao.dropColumn(dropProperty.entity.tableName, dropProperty.column);
        }
    }
}

