/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dql.instance;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.statement.dql.AbstractDQLDatabaseStatement;
import com.alibaba.fastjson.JSONArray;
import java.util.Arrays;
import java.util.List;

public class FetchListDatabaseStatement
extends AbstractDQLDatabaseStatement {
    private Entity entity;
    private String column;
    private Object value;

    public FetchListDatabaseStatement(Entity entity, String column, Object value, QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.entity = entity;
        this.column = column;
        this.value = value;
    }

    @Override
    public JSONArray getArray() {
        return this.getArray(this.entity, "t");
    }

    @Override
    public String getStatement() {
        String key = "fetch_" + this.entity.tableName + "_" + this.column + "_" + this.quickDAOConfig.databaseProvider.name();
        if (!this.quickDAOConfig.statementCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder("select ");
            builder.append(this.columns(this.entity, "t"));
            Property property = this.entity.getPropertyByFieldName(this.column);
            builder.append(" from " + this.quickDAOConfig.databaseProvider.escape(this.entity.tableName) + " t where t." + this.quickDAOConfig.databaseProvider.escape(property.column) + " = " + (null == property.function ? "?" : property.function) + "");
            this.quickDAOConfig.statementCache.put(key, builder.toString());
        }
        String sql = this.quickDAOConfig.statementCache.get(key);
        return sql;
    }

    @Override
    public List getParameters() {
        return Arrays.asList(this.value);
    }

    @Override
    public String name() {
        return "\u5355\u5b57\u6bb5\u67e5\u8be2";
    }
}

