/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dml.json;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;
import cn.schoolwow.quickdao.statement.dml.AbstractDMLDatabaseStatement;
import cn.schoolwow.quickdao.statement.dql.instance.SelectExistsValueBySingleFieldDatabaseStatement;
import cn.schoolwow.quickdao.statement.dql.json.SelectCountByUniqueFieldsDatabaseStatement;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AbstractDMLJSONDatabaseStatement
extends AbstractDMLDatabaseStatement {
    public AbstractDMLJSONDatabaseStatement(ManipulationOption option, QuickDAOConfig quickDAOConfig) {
        super(option, quickDAOConfig);
    }

    protected void distinguishJSONArrayBySingleField(String tableName, JSONArray instances, String column, JSONArray insertArray, JSONArray updateArray) {
        ArrayList<Object> parameters = new ArrayList<Object>(instances.size());
        for (int i = 0; i < instances.size(); ++i) {
            Object value = instances.getJSONObject(i).get((Object)column);
            if (null == value) continue;
            parameters.add(value);
        }
        SelectExistsValueBySingleFieldDatabaseStatement selectExistsValueBySingleFieldDatabaseStatement = new SelectExistsValueBySingleFieldDatabaseStatement(tableName, column, parameters, this.quickDAOConfig);
        List<String> existValues = selectExistsValueBySingleFieldDatabaseStatement.getSingleColumnList();
        for (int i = 0; i < instances.size(); ++i) {
            JSONObject instance = instances.getJSONObject(i);
            String value = instance.getString(column);
            if (null != insertArray && !existValues.contains(value)) {
                insertArray.add((Object)instance);
                continue;
            }
            if (null == updateArray) continue;
            updateArray.add((Object)instance);
        }
    }

    protected void distinguishJSONArrayByMultipleField(String tableName, JSONArray instances, JSONArray insertArray, JSONArray updateArray) {
        for (int i = 0; i < instances.size(); ++i) {
            JSONObject instance = instances.getJSONObject(i);
            SelectCountByUniqueFieldsDatabaseStatement selectCountByUniqueFieldsDatabaseStatement = new SelectCountByUniqueFieldsDatabaseStatement(tableName, instance, this.option.uniqueFieldNames, this.quickDAOConfig);
            int count = selectCountByUniqueFieldsDatabaseStatement.getCount();
            if (null != insertArray && count <= 0) {
                insertArray.add((Object)instance);
                continue;
            }
            if (null == updateArray) continue;
            updateArray.add((Object)instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeBatch(JSONArray instances) {
        this.connectionExecutor.returnGeneratedKeys(false).name(this.name()).sql(this.getStatement());
        int effect = 0;
        for (int i = 0; i < instances.size(); i += this.option.perBatchCount) {
            this.connectionExecutor.startBatch();
            try {
                int end = Math.min(i + this.option.perBatchCount, instances.size());
                int j = i;
                while (j < end) {
                    this.index = j++;
                    List parameters = this.getParameters();
                    this.connectionExecutor.batchParameters(parameters);
                }
                effect += this.connectionExecutor.executeBatch();
                continue;
            }
            finally {
                this.connectionExecutor.closeBatch();
            }
        }
        return effect;
    }

    protected List<String> getPartColumns(JSONObject instance) {
        ArrayList<String> columns = null;
        if (this.option.partColumnSet.isEmpty()) {
            Set keySet = instance.keySet();
            columns = new ArrayList(keySet.size());
            for (String key : keySet) {
                columns.add(key);
            }
        } else {
            columns = new ArrayList<String>(this.option.partColumnSet);
        }
        return columns;
    }
}

