/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dml.instance;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;
import cn.schoolwow.quickdao.statement.dml.instance.AbstractDMLInstanceDatabaseStatement;
import cn.schoolwow.quickdao.util.ParametersUtil;
import java.util.ArrayList;
import java.util.List;

public class UpdateInstanceByUniqueKeyDatabaseStatement
extends AbstractDMLInstanceDatabaseStatement {
    private Entity entity;
    private Object[] instances;
    private List<Property> propertyList;

    public UpdateInstanceByUniqueKeyDatabaseStatement(Object[] instances, ManipulationOption option, QuickDAOConfig quickDAOConfig) {
        super(option, quickDAOConfig);
        this.entity = quickDAOConfig.getEntityByClassName(instances[0].getClass().getName());
        this.instances = instances;
        this.propertyList = this.getPartColumnPropertyList(this.entity);
    }

    @Override
    public int executeUpdate() {
        return this.executeBatch(this.instances);
    }

    @Override
    public String getStatement() {
        String key = "updateByUniqueKey_" + this.entity.tableName + "_" + this.quickDAOConfig.databaseProvider.name();
        if (this.option.partColumnSet.isEmpty()) {
            if (!this.quickDAOConfig.statementCache.contains(key)) {
                String sql = this.generateUpdateByUniqueKeyStatement(this.entity.properties);
                this.quickDAOConfig.statementCache.put(key, sql);
            }
            return this.quickDAOConfig.statementCache.get(key);
        }
        String sql = this.generateUpdateByUniqueKeyStatement(this.propertyList);
        return sql;
    }

    @Override
    public List getParameters() {
        Object value;
        Object instance = this.instances[this.index];
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (Property property : this.propertyList) {
            if (property.id || this.entity.uniqueProperties.contains(property) || property.createdAt) continue;
            if (property.updateAt) {
                ParametersUtil.setCurrentDateTime(property, instance);
            }
            value = null;
            if (null != this.quickDAOConfig.databaseOption.updateColumnValueFunction) {
                value = this.quickDAOConfig.databaseOption.updateColumnValueFunction.apply(property);
            }
            if (null == value) {
                value = ParametersUtil.getFieldValueFromInstance(instance, property.name);
            }
            parameterList.add(value);
        }
        for (Property property : this.entity.uniqueProperties) {
            value = ParametersUtil.getFieldValueFromInstance(instance, property.name);
            parameterList.add(value);
        }
        return parameterList;
    }

    @Override
    public String name() {
        return "\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u66f4\u65b0\u8bb0\u5f55";
    }

    private String generateUpdateByUniqueKeyStatement(List<Property> propertyList) {
        StringBuilder builder = new StringBuilder();
        builder.append("update " + this.quickDAOConfig.databaseProvider.escape(this.entity.tableName) + " set ");
        for (Property property : propertyList) {
            if (property.id || this.entity.uniqueProperties.contains(property) || property.createdAt || !this.option.partColumnSet.isEmpty() && !this.option.partColumnSet.contains(property.column) && !this.option.partColumnSet.contains(property.name)) continue;
            builder.append(this.quickDAOConfig.databaseProvider.escape(property.column) + " = " + (null == property.function ? "?" : property.function) + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(" where ");
        for (Property property : this.entity.properties) {
            if (!this.entity.uniqueProperties.contains(property) || property.id) continue;
            builder.append(this.quickDAOConfig.databaseProvider.escape(property.column) + " = ? and ");
        }
        builder.delete(builder.length() - 5, builder.length());
        return builder.toString();
    }
}

