/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dml.instance;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;
import cn.schoolwow.quickdao.statement.dml.instance.AbstractDMLInstanceDatabaseStatement;
import cn.schoolwow.quickdao.util.ParametersUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class InsertInstanceDatabaseStatement
extends AbstractDMLInstanceDatabaseStatement {
    private Entity entity;
    protected Object[] instances;
    private List<Property> propertyList;

    public InsertInstanceDatabaseStatement(Object[] instances, ManipulationOption option, QuickDAOConfig quickDAOConfig) {
        super(option, quickDAOConfig);
        this.entity = quickDAOConfig.getEntityByClassName(instances[0].getClass().getName());
        this.instances = instances;
        this.propertyList = this.getPartColumnPropertyList(this.entity);
    }

    @Override
    public int executeUpdate() {
        this.connectionExecutor.name(this.name()).returnGeneratedKeys(this.option.returnGeneratedKeys).sql(this.getStatement());
        int effect = 0;
        for (int i = 0; i < this.instances.length; ++i) {
            this.index = i;
            Object instance = this.instances[i];
            List parameters = this.getParameters();
            effect += this.connectionExecutor.parameters(parameters).executeUpdate();
            if (!this.option.returnGeneratedKeys || null == this.entity.id || !this.entity.id.strategy.equals((Object)IdStrategy.AutoIncrement)) continue;
            String[] generatedKeysValue = new String[1];
            switch (this.quickDAOConfig.databaseProvider.name().toLowerCase()) {
                case "oracle": {
                    String getIdValueSQL = "select " + this.entity.tableName + "_seq.currVal from dual";
                    this.connectionExecutor.name("\u83b7\u53d6\u81ea\u589eid").sql(getIdValueSQL).executeQuery(resultSet -> {
                        if (resultSet.next()) {
                            generatedKeysValue[0] = resultSet.getString(1);
                        }
                    });
                    break;
                }
                default: {
                    generatedKeysValue[0] = this.connectionExecutor.getGeneratedKeys();
                }
            }
            ParametersUtil.setGeneratedKeysValue(instance, this.entity, generatedKeysValue[0]);
        }
        return effect;
    }

    @Override
    public String getStatement() {
        String key = "insert_" + this.entity.tableName + "_" + this.quickDAOConfig.databaseProvider.name();
        if (this.option.partColumnSet.isEmpty()) {
            if (!this.quickDAOConfig.statementCache.contains(key)) {
                String sql = this.generateInsertStatement(this.entity.properties);
                this.quickDAOConfig.statementCache.put(key, sql);
            }
            return this.quickDAOConfig.statementCache.get(key);
        }
        String sql = this.generateInsertStatement(this.propertyList);
        return sql;
    }

    @Override
    public List getParameters() {
        ArrayList<Object> parameterList = new ArrayList<Object>();
        Object instance = this.instances[this.index];
        for (Property property : this.propertyList) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) continue;
            if (property.id && property.strategy == IdStrategy.IdGenerator) {
                this.setNextGenerateId(property, instance);
            }
            if (property.createdAt || property.updateAt) {
                ParametersUtil.setCurrentDateTime(property, instance);
            }
            Object value = null;
            if (null != this.quickDAOConfig.databaseOption.insertColumnValueFunction) {
                value = this.quickDAOConfig.databaseOption.insertColumnValueFunction.apply(property);
            }
            if (null == value) {
                value = ParametersUtil.getFieldValueFromInstance(instance, property.name);
            }
            parameterList.add(value);
        }
        return parameterList;
    }

    @Override
    public String name() {
        return "\u63d2\u5165\u8bb0\u5f55";
    }

    private String generateInsertStatement(List<Property> properties) {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into " + this.quickDAOConfig.databaseProvider.escape(this.entity.tableName) + "(");
        for (Property property : properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement || !this.option.partColumnSet.isEmpty() && !this.option.partColumnSet.contains(property.column) && !this.option.partColumnSet.contains(property.name)) continue;
            builder.append(this.quickDAOConfig.databaseProvider.escape(property.column) + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(") values(");
        for (Property property : properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) continue;
            builder.append((null == property.function ? "?" : property.function) + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        return builder.toString();
    }

    private void setNextGenerateId(Property property, Object instance) {
        Field idField = ParametersUtil.getFieldFromInstance(instance, property.name);
        String value = this.quickDAOConfig.databaseOption.idGenerator.getNextId();
        try {
            switch (idField.getType().getName()) {
                case "int": {
                    idField.setInt(instance, Integer.parseInt(value));
                    break;
                }
                case "java.lang.Integer": {
                    idField.set(instance, Integer.parseInt(value));
                    break;
                }
                case "long": {
                    idField.setLong(instance, Long.parseLong(value));
                    break;
                }
                case "java.lang.Long": {
                    idField.set(instance, Long.parseLong(value));
                    break;
                }
                case "java.lang.String": {
                    idField.set(instance, value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u5f53\u524d\u4ec5\u652f\u6301int,long,String\u7c7b\u578b\u7684\u81ea\u589e\u4e3b\u952e!\u81ea\u589e\u5b57\u6bb5\u540d\u79f0:" + idField.getName() + ",\u7c7b\u578b:" + idField.getType().getName() + "!");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bbe\u7f6e\u81ea\u589e\u5b57\u6bb5\u503c\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
    }
}

