/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.domain.external;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.transaction.Transaction;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.internal.DatabaseOption;
import cn.schoolwow.quickdao.domain.internal.EntityOption;
import cn.schoolwow.quickdao.provider.DatabaseProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickDAOConfig {
    private Logger logger = LoggerFactory.getLogger(QuickDAOConfig.class);
    public DataSource dataSource;
    public EntityOption entityOption = new EntityOption();
    public Function<Property, Class> queryColumnTypeMapping;
    public DatabaseOption databaseOption = new DatabaseOption();
    public Map<String, Entity> entityMap;
    public final Map<String, Entity> databaseTableCache = new ConcurrentHashMap<String, Entity>();
    public final ConcurrentHashMap<String, String> statementCache = new ConcurrentHashMap();
    public DatabaseProvider databaseProvider;
    public DAO dao;
    public boolean record;
    public StringBuffer sqlRecordBuilder = new StringBuffer();
    public ThreadLocal<Transaction> transactionThreadLocal = new ThreadLocal();

    public Entity getEntityByClassName(String className) {
        if (this.entityMap.containsKey(className)) {
            return this.entityMap.get(className);
        }
        throw new IllegalArgumentException("\u626b\u63cf\u5b9e\u4f53\u7c7b\u5217\u8868\u4e2d\u4e0d\u5305\u542b\u8be5\u5b9e\u4f53\u7c7b!\u7c7b\u540d:" + className);
    }

    public Entity getDatabaseEntityByTableName(String tableName) {
        if (!this.databaseTableCache.containsKey(tableName)) {
            Entity entity = this.dao.getDatabaseEntity(tableName);
            if (null == entity) {
                return null;
            }
            this.databaseTableCache.put(tableName, entity);
        }
        return this.databaseTableCache.get(tableName);
    }

    public void deleteDatabaseEntityCache(String tableName) {
        Iterator<Map.Entry<String, String>> entryIterator = this.statementCache.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, String> entry = entryIterator.next();
            if (!entry.getKey().contains("_" + tableName + "_")) continue;
            this.logger.trace("\u5220\u9664SQL\u8bed\u53e5\u7f13\u5b58:{}", (Object)entry.getKey());
            entryIterator.remove();
        }
        this.logger.trace("\u5220\u9664\u6570\u636e\u5e93\u8868\u7f13\u5b58,\u8868\u540d:{}", (Object)tableName);
        this.databaseTableCache.remove(tableName);
    }

    public String toString() {
        return "\n{\n\u6570\u636e\u6e90:" + this.dataSource + "\n\u626b\u63cf\u540e\u7684\u5b9e\u4f53\u7c7b\u4fe1\u606f\u4e2a\u6570:" + this.entityMap.size() + "\nSQL\u8bed\u53e5\u7f13\u5b58\u4e2a\u6570:" + this.statementCache.size() + "\n\u6570\u636e\u5e93\u7c7b\u578b:" + this.databaseProvider.name() + "\n}\n";
    }
}

