/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.ddl;

import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.dao.ddl.MySQLDatabaseDefinition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class H2DatabaseDefinition
extends MySQLDatabaseDefinition {
    public H2DatabaseDefinition(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public boolean hasTable(String tableName) {
        String hasTableSQL = "select table_name from information_schema.tables where table_name = ?;";
        return this.connectionExecutor.name("\u5224\u65ad\u8868\u662f\u5426\u5b58\u5728").sql(hasTableSQL).parameters(Arrays.asList(tableName.toUpperCase())).executeAndCheckExists();
    }

    @Override
    public boolean hasColumn(String tableName, String columnName) {
        String hasTableColumnSQL = "select table_name, column_name from information_schema.`columns` where table_schema = 'PUBLIC' and table_name = ? and column_name = ?;";
        List<String> parameters = Arrays.asList(tableName.toUpperCase(), columnName.toUpperCase());
        return this.connectionExecutor.name("\u5224\u65ad\u8868\u6307\u5b9a\u5217\u662f\u5426\u5b58\u5728").sql(hasTableColumnSQL).parameters(parameters).executeAndCheckExists();
    }

    @Override
    public Property createColumn(String tableName, Property property) {
        return super.createColumn(tableName.toUpperCase(), property);
    }

    @Override
    public List<String> getTableNameList() {
        String getEntityListSQL = "show tables;";
        ArrayList<String> tableNames = new ArrayList<String>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u540d\u5217\u8868").sql(getEntityListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                tableNames.add(resultSet.getString(1));
            }
        });
        return tableNames;
    }

    @Override
    public List<Entity> getDatabaseEntityList() {
        String getEntityListSQL = "show tables;";
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5217\u8868").sql(getEntityListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                Entity entity = new Entity();
                entity.tableName = resultSet.getString(1);
                entity.properties = this.getPropertyList(entity.tableName);
                entityList.add(entity);
            }
        });
        this.getIndex(entityList);
        return entityList;
    }

    @Override
    public Entity getDatabaseEntity(String tableName) {
        List<Entity> entityList = this.getDatabaseEntityList();
        for (Entity entity : entityList) {
            if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
            entity.properties = this.getPropertyList(entity.tableName);
            entity.indexFieldList = this.getIndexField(tableName);
            return entity;
        }
        return null;
    }

    @Override
    public List<Property> getPropertyList(String tableName) {
        String getTableColumnSQL = "select table_name, column_name, type_name, character_maximum_length, is_nullable, column_default from information_schema.`columns` where table_schema = 'PUBLIC' and table_name = ?;";
        ArrayList<Property> propertyList = new ArrayList<Property>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5b57\u6bb5\u5217\u8868").sql(getTableColumnSQL).parameters(Arrays.asList(tableName.toUpperCase())).executeQuery(resultSet -> {
            while (resultSet.next()) {
                Property property = new Property();
                this.getProperty(property, (ResultSet)resultSet);
                propertyList.add(property);
            }
        });
        return propertyList;
    }

    @Override
    public Property getProperty(String tableName, String columnName) {
        String getTableColumnSQL = "select table_name, column_name, type_name, character_maximum_length, is_nullable, column_default from information_schema.`columns` where table_schema = 'PUBLIC' and table_name = ? and column_name = ?;";
        List<String> parameters = Arrays.asList(tableName.toUpperCase(), columnName.toUpperCase());
        Property property = new Property();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f").sql(getTableColumnSQL).parameters(parameters).executeQuery(resultSet -> {
            if (resultSet.next()) {
                this.getProperty(property, (ResultSet)resultSet);
            }
        });
        return null == property.column ? null : property;
    }

    @Override
    public boolean hasIndex(String tableName, String indexName) {
        String hasIndexExistsSQL = "select index_name from information_schema.indexes where index_name = ?;";
        return this.connectionExecutor.name("\u5224\u65ad\u7d22\u5f15\u662f\u5426\u5b58\u5728").sql(hasIndexExistsSQL).parameters(Arrays.asList(indexName.toUpperCase())).executeAndCheckExists();
    }

    @Override
    public List<IndexField> getIndexField(String tableName) {
        String getIndexSQL = "select table_name, sql from information_schema.indexes where table_name = ?";
        ArrayList<IndexField> indexFieldList = new ArrayList<IndexField>();
        this.connectionExecutor.name("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f").sql(getIndexSQL).parameters(Arrays.asList(tableName.toUpperCase())).executeQuery(resultSet -> {
            while (resultSet.next()) {
                IndexField indexField = this.getIndexField((ResultSet)resultSet);
                indexFieldList.add(indexField);
            }
        });
        return indexFieldList;
    }

    @Override
    protected void getIndex(List<Entity> entityList) {
        String getIndexSQL = "select table_name, sql from information_schema.indexes";
        this.connectionExecutor.name("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f").sql(getIndexSQL).executeQuery(resultSet -> {
            block0: while (resultSet.next()) {
                for (Entity entity : entityList) {
                    if (!entity.tableName.equalsIgnoreCase(resultSet.getString("table_name"))) continue;
                    IndexField indexField = this.getIndexField((ResultSet)resultSet);
                    entity.indexFieldList.add(indexField);
                    continue block0;
                }
            }
        });
    }

    private Property getProperty(Property property, ResultSet resultSet) throws SQLException {
        Object character_maximum_length;
        property.column = resultSet.getString("column_name");
        property.columnType = resultSet.getString("type_name");
        if (property.columnType.contains(" ")) {
            property.columnType = property.columnType.substring(0, property.columnType.indexOf(" "));
        }
        if (null != (character_maximum_length = resultSet.getObject("character_maximum_length")) && character_maximum_length.toString().length() < 7) {
            property.length = Integer.parseInt(character_maximum_length.toString());
        }
        property.notNull = "NO".equals(resultSet.getString("is_nullable"));
        if (null != resultSet.getString("column_default")) {
            property.defaultValue = resultSet.getString("column_default");
        }
        return property;
    }

    private IndexField getIndexField(ResultSet resultSet) throws SQLException {
        String sql = resultSet.getString("sql");
        String[] tokens = sql.split("\"");
        IndexField indexField = new IndexField();
        indexField.indexType = tokens[0].contains("UNIQUE") ? IndexType.UNIQUE : IndexType.NORMAL;
        indexField.indexName = tokens[3];
        indexField.tableName = tokens[7];
        for (int i = 9; i < tokens.length - 1; ++i) {
            indexField.columns.add(tokens[i]);
        }
        return indexField;
    }
}

