/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.dcl;

import cn.schoolwow.quickdao.dao.dcl.AbstractDabaseControl;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.dcl.DataBaseUser;
import cn.schoolwow.quickdao.domain.external.dcl.GrantOption;
import java.util.ArrayList;
import java.util.List;

public class MySQLDatabaseControl
extends AbstractDabaseControl {
    public MySQLDatabaseControl(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public List<String> getUserNameList() {
        String getUserNameListSQL = "select distinct user from mysql.user;";
        ArrayList<String> userNameList = new ArrayList<String>();
        this.connectionExecutor.name("\u83b7\u53d6\u7528\u6237\u5217\u8868").sql(getUserNameListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                userNameList.add(resultSet.getString(1));
            }
        });
        return userNameList;
    }

    @Override
    public void createUser(DataBaseUser dataBaseUser) {
        String createUserSQL = "create user '" + dataBaseUser.username + "'@'" + dataBaseUser.host + "' identified by '" + dataBaseUser.password + "';";
        this.connectionExecutor.name("\u521b\u5efa\u7528\u6237").sql(createUserSQL).executeUpdate();
    }

    @Override
    public void modifyPassword(String username, String newPassword) {
        String modifyPasswordSQL = "set password for " + username + " = password('" + newPassword + "');";
        this.connectionExecutor.name("\u66f4\u6539\u5bc6\u7801").sql(modifyPasswordSQL).executeUpdate();
    }

    @Override
    public void deleteUser(DataBaseUser dataBaseUser) {
        String deleteUserSQL = "drop user " + dataBaseUser.username + "@'" + dataBaseUser.host + "';";
        this.connectionExecutor.name("\u5220\u9664\u7528\u6237").sql(deleteUserSQL).executeUpdate();
    }

    @Override
    public void grant(GrantOption grantOption) {
        String grantSQL = "grant " + grantOption.privileges + " on " + grantOption.databaseName + ".* to '" + grantOption.dataBaseUser.username + "'@'" + grantOption.dataBaseUser.host + "';";
        this.connectionExecutor.name("\u6570\u636e\u5e93\u6388\u6743").sql(grantSQL).executeUpdate();
        this.flushPrivileges();
    }

    @Override
    public void createUserAndGrant(GrantOption grantOption) {
        String createUserAndGrantSQL = "grant " + grantOption.privileges + " on " + grantOption.databaseName + ".* to '" + grantOption.dataBaseUser.username + "'@'" + grantOption.dataBaseUser.host + "' identified by '" + grantOption.dataBaseUser.password + "';";
        this.connectionExecutor.name("\u521b\u5efa\u7528\u6237\u5e76\u6388\u6743").sql(createUserAndGrantSQL).executeUpdate();
        this.flushPrivileges();
    }

    @Override
    public void revoke(GrantOption grantOption) {
        String revokeSQL = "revoke " + grantOption.privileges + " on " + grantOption.databaseName + ".* from '" + grantOption.dataBaseUser.username + "'@'" + grantOption.dataBaseUser.host + "';";
        this.connectionExecutor.name("\u6536\u56de\u6743\u9650").sql(revokeSQL).executeUpdate();
        this.flushPrivileges();
    }

    @Override
    public void flushPrivileges() {
        String flushPrivilegesSQL = "flush privileges;";
        this.connectionExecutor.name("\u5237\u65b0\u6743\u9650").sql(flushPrivilegesSQL).executeUpdate();
    }
}

