/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.DAOInvocationHandler;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.StatementListener;
import cn.schoolwow.quickdao.domain.external.generator.IDGenerator;
import cn.schoolwow.quickdao.domain.internal.DatabaseUpgrade;
import cn.schoolwow.quickdao.entity.TableDefiner;
import cn.schoolwow.quickdao.entity.TableDefinerImpl;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import cn.schoolwow.quickdao.provider.AbstractDatabaseProvider;
import cn.schoolwow.quickdao.provider.DatabaseProvider;
import cn.schoolwow.quickdao.provider.H2DatabaseProvider;
import cn.schoolwow.quickdao.provider.MariaDBDatabaseProvider;
import cn.schoolwow.quickdao.provider.MySQLDatabaseProvider;
import cn.schoolwow.quickdao.provider.OracleDatabaseProvider;
import cn.schoolwow.quickdao.provider.PostgreDatabaseProvider;
import cn.schoolwow.quickdao.provider.SQLServerDatabaseProvider;
import cn.schoolwow.quickdao.provider.SQLiteDatabaseProvider;
import cn.schoolwow.quickdao.util.DatabaseUtil;
import cn.schoolwow.quickdao.util.EntityUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickDAO {
    private Logger logger = LoggerFactory.getLogger(QuickDAO.class);
    private static List<DatabaseProvider> databaseProviders = new ArrayList<AbstractDatabaseProvider>(Arrays.asList(new H2DatabaseProvider(), new MariaDBDatabaseProvider(), new MySQLDatabaseProvider(), new OracleDatabaseProvider(), new PostgreDatabaseProvider(), new SQLiteDatabaseProvider(), new SQLServerDatabaseProvider()));
    private QuickDAOConfig quickDAOConfig = new QuickDAOConfig();

    public static void addDatabaseProvider(DatabaseProvider databaseProvider) {
        databaseProviders.add(databaseProvider);
    }

    public static QuickDAO newInstance() {
        return new QuickDAO();
    }

    private QuickDAO() {
    }

    public QuickDAO dataSource(DataSource dataSource) {
        this.quickDAOConfig.dataSource = dataSource;
        try {
            Connection connection = this.quickDAOConfig.dataSource.getConnection();
            connection.setAutoCommit(false);
            String jdbcUrl = connection.getMetaData().getURL();
            for (DatabaseProvider databaseProvider : databaseProviders) {
                if (!jdbcUrl.contains("jdbc:" + databaseProvider.name())) continue;
                this.quickDAOConfig.databaseProvider = databaseProvider;
                break;
            }
            if (null == this.quickDAOConfig.databaseProvider) {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!jdbcurl:" + jdbcUrl);
            }
            this.logger.info("[\u6570\u636e\u6e90]\u7c7b\u578b:{},\u5730\u5740:{}", (Object)this.quickDAOConfig.databaseProvider.name(), (Object)jdbcUrl);
            connection.close();
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        return this;
    }

    public QuickDAO packageName(String packageName) {
        this.quickDAOConfig.entityOption.packageNameMap.put(packageName, "");
        return this;
    }

    public QuickDAO packageName(String packageName, String prefix) {
        this.quickDAOConfig.entityOption.packageNameMap.put(packageName, prefix + "_");
        return this;
    }

    public QuickDAO entity(Class ... entityClasses) {
        for (Class entityClass : entityClasses) {
            this.quickDAOConfig.entityOption.entityClassMap.put(entityClass, "");
        }
        return this;
    }

    public QuickDAO entity(Class entityClass, String prefix) {
        this.quickDAOConfig.entityOption.entityClassMap.put(entityClass, prefix);
        return this;
    }

    public QuickDAO ignorePackageName(String ignorePackageName) {
        if (this.quickDAOConfig.entityOption.ignorePackageNameList == null) {
            this.quickDAOConfig.entityOption.ignorePackageNameList = new ArrayList<String>();
        }
        this.quickDAOConfig.entityOption.ignorePackageNameList.add(ignorePackageName);
        return this;
    }

    public QuickDAO ignoreClass(Class ignoreClass) {
        if (this.quickDAOConfig.entityOption.ignoreClassList == null) {
            this.quickDAOConfig.entityOption.ignoreClassList = new ArrayList<Class>();
        }
        this.quickDAOConfig.entityOption.ignoreClassList.add(ignoreClass);
        return this;
    }

    public QuickDAO filter(Predicate<Class> ignorePredicate) {
        this.quickDAOConfig.entityOption.ignorePredicate = ignorePredicate;
        return this;
    }

    public QuickDAO foreignKey(boolean openForeignKey) {
        this.quickDAOConfig.databaseOption.openForeignKey = openForeignKey;
        return this;
    }

    public QuickDAO automaticCreateTable(boolean autoCreateTable) {
        this.quickDAOConfig.databaseOption.automaticCreateTable = autoCreateTable;
        return this;
    }

    public QuickDAO automaticCreateProperty(boolean autoCreateProperty) {
        this.quickDAOConfig.databaseOption.automaticCreateProperty = autoCreateProperty;
        return this;
    }

    public QuickDAO automaticDeleteTableAndProperty(boolean autoDeleteTableAndProperty) {
        this.quickDAOConfig.databaseOption.automaticDeleteTableAndProperty = autoDeleteTableAndProperty;
        return this;
    }

    public QuickDAO idStrategy(IdStrategy idStrategy) {
        this.quickDAOConfig.databaseOption.idStrategy = idStrategy;
        return this;
    }

    public QuickDAO idGenerator(IDGenerator idGenerator) {
        this.quickDAOConfig.databaseOption.idGenerator = idGenerator;
        return this;
    }

    public QuickDAO columnTypeMapping(Function<Property, Class> columnTypeMapping) {
        this.quickDAOConfig.queryColumnTypeMapping = columnTypeMapping;
        return this;
    }

    public QuickDAO perBatchCount(int perBatchCount) {
        this.quickDAOConfig.databaseOption.perBatchCount = perBatchCount;
        return this;
    }

    public QuickDAO insertColumnValueFunction(Function<Property, Object> insertColumnValueFunction) {
        this.quickDAOConfig.databaseOption.insertColumnValueFunction = insertColumnValueFunction;
        return this;
    }

    public QuickDAO updateColumnValueFunction(Function<Property, Object> updateColumnValueFunction) {
        this.quickDAOConfig.databaseOption.updateColumnValueFunction = updateColumnValueFunction;
        return this;
    }

    public QuickDAO virtualTableName(String ... virtualTableNames) {
        this.quickDAOConfig.databaseOption.virtualTableNameList.addAll(Arrays.asList(virtualTableNames));
        return this;
    }

    public QuickDAO statementListener(StatementListener statementListener) {
        this.quickDAOConfig.databaseOption.statementListener.add(statementListener);
        return this;
    }

    public TableDefiner define(Class clazz) {
        if (null == this.quickDAOConfig.dataSource) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528dataSource\u65b9\u6cd5\u914d\u7f6e\u6570\u636e\u6e90!");
        }
        this.getEntityMap();
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return new TableDefinerImpl(entity, this);
    }

    public DAO build() {
        DAO daoProxy;
        if (null == this.quickDAOConfig.databaseProvider) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528dataSource\u65b9\u6cd5\u914d\u7f6e\u6570\u636e\u6e90!");
        }
        this.entity(DatabaseUpgrade.class);
        this.getEntityMap();
        DAOInvocationHandler daoInvocationHandler = new DAOInvocationHandler(this.quickDAOConfig);
        this.quickDAOConfig.dao = daoProxy = (DAO)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{DAO.class}, (InvocationHandler)daoInvocationHandler);
        if (this.quickDAOConfig.databaseOption.automaticCreateTable) {
            this.logger.trace("\u51c6\u5907\u6267\u884c\u81ea\u52a8\u521b\u5efa\u8868");
            DatabaseUtil.automaticCreateTable(this.quickDAOConfig);
        }
        if (this.quickDAOConfig.databaseOption.automaticCreateProperty) {
            this.logger.trace("\u51c6\u5907\u6267\u884c\u81ea\u52a8\u521b\u5efa\u8868\u5b57\u6bb5");
            DatabaseUtil.automaticCreateProperty(this.quickDAOConfig);
        }
        if (this.quickDAOConfig.databaseOption.automaticDeleteTableAndProperty) {
            this.logger.trace("\u51c6\u5907\u6267\u884c\u81ea\u52a8\u5220\u9664\u8868\u548c\u5b57\u6bb5");
            DatabaseUtil.automaticDeleteTableAndProperty(daoProxy);
        }
        return daoProxy;
    }

    private void getEntityMap() {
        if (null == this.quickDAOConfig.entityMap || this.quickDAOConfig.entityMap.isEmpty()) {
            this.quickDAOConfig.entityOption.databaseProvider = this.quickDAOConfig.databaseProvider;
            this.quickDAOConfig.entityMap = EntityUtil.getEntityMap(this.quickDAOConfig.entityOption);
        }
    }
}

