/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dql.instance;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.statement.dql.AbstractDQLDatabaseStatement;
import com.alibaba.fastjson.JSONArray;
import java.util.Collections;
import java.util.List;

public class FetchNullDatabaseStatement
extends AbstractDQLDatabaseStatement {
    private Entity entity;
    private String column;

    public FetchNullDatabaseStatement(Entity entity, String column, QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.entity = entity;
        this.column = column;
    }

    @Override
    public JSONArray getArray() {
        return this.getArray(this.entity, "t");
    }

    @Override
    public String getStatement() {
        String key = "fetchNull_" + this.entity.tableName + "_" + this.column + "_" + this.quickDAOConfig.databaseProvider.name();
        if (!this.quickDAOConfig.statementCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder("select ");
            builder.append(this.columns(this.entity, "t"));
            Property property = this.entity.getPropertyByFieldName(this.column);
            builder.append(" from " + this.quickDAOConfig.databaseProvider.escape(this.entity.tableName) + " as t where t." + this.quickDAOConfig.databaseProvider.escape(property.column) + " is null");
            this.quickDAOConfig.statementCache.put(key, builder.toString());
        }
        String sql = this.quickDAOConfig.statementCache.get(key);
        return sql;
    }

    @Override
    public List getParameters() {
        return Collections.emptyList();
    }

    @Override
    public String name() {
        return "\u67e5\u8be2\u5b57\u6bb5\u4e3aNULL\u7684\u8bb0\u5f55";
    }
}

