/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dml.json;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;
import cn.schoolwow.quickdao.statement.dml.json.AbstractDMLJSONDatabaseStatement;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class InsertJSONObjectDatabaseStatement
extends AbstractDMLJSONDatabaseStatement {
    private String tableName;
    private JSONObject instance;
    private List<String> columns;

    public InsertJSONObjectDatabaseStatement(String tableName, JSONObject instance, ManipulationOption option, QuickDAOConfig quickDAOConfig) {
        super(option, quickDAOConfig);
        this.tableName = tableName;
        this.instance = instance;
        this.columns = this.getPartColumns(instance);
    }

    @Override
    public int executeUpdate() {
        int effect = super.executeUpdate();
        this.instance.put("generateKeys", (Object)this.connectionExecutor.getGeneratedKeys());
        return effect;
    }

    @Override
    public String getStatement() {
        StringBuilder builder = new StringBuilder("insert into " + this.quickDAOConfig.databaseProvider.escape(this.tableName) + "(");
        for (String column : this.columns) {
            builder.append(this.quickDAOConfig.databaseProvider.escape(column) + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(") values(");
        for (String column : this.columns) {
            builder.append("?,");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        String sql = builder.toString();
        return sql;
    }

    @Override
    public List getParameters() {
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (String column : this.columns) {
            Object value = this.instance.get((Object)column);
            parameterList.add(value);
        }
        return parameterList;
    }

    @Override
    public String name() {
        return "JSONObject\u63d2\u5165";
    }
}

