/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dml.instance;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;
import cn.schoolwow.quickdao.statement.dml.instance.AbstractDMLInstanceDatabaseStatement;
import cn.schoolwow.quickdao.util.ParametersUtil;
import java.util.ArrayList;
import java.util.List;

public class UpdateInstanceByIdDatabaseStatement
extends AbstractDMLInstanceDatabaseStatement {
    private Entity entity;
    private Object[] instances;
    private List<Property> propertyList;

    public UpdateInstanceByIdDatabaseStatement(Object[] instances, ManipulationOption option, QuickDAOConfig quickDAOConfig) {
        super(option, quickDAOConfig);
        this.entity = quickDAOConfig.getEntityByClassName(instances[0].getClass().getName());
        this.instances = instances;
        this.propertyList = this.getPartColumnPropertyList(this.entity);
    }

    @Override
    public int executeUpdate() {
        return this.executeBatch(this.instances);
    }

    @Override
    public String getStatement() {
        String key = "updateById_" + this.entity.tableName + "_" + this.quickDAOConfig.databaseProvider.name();
        if (this.option.partColumnSet.isEmpty()) {
            if (!this.quickDAOConfig.statementCache.contains(key)) {
                String sql = this.generateUpdateByIdStatement(this.entity.properties);
                this.quickDAOConfig.statementCache.put(key, sql);
            }
            return this.quickDAOConfig.statementCache.get(key);
        }
        String sql = this.generateUpdateByIdStatement(this.propertyList);
        return sql;
    }

    @Override
    public List getParameters() {
        Object instance = this.instances[this.index];
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (Property property : this.propertyList) {
            if (property.id || property.createdAt) continue;
            if (property.updateAt) {
                ParametersUtil.setCurrentDateTime(property, instance);
            }
            Object value = null;
            if (null != this.quickDAOConfig.databaseOption.updateColumnValueFunction) {
                value = this.quickDAOConfig.databaseOption.updateColumnValueFunction.apply(property);
            }
            if (null == value) {
                value = ParametersUtil.getFieldValueFromInstance(instance, property.name);
            }
            parameterList.add(value);
        }
        Object idValue = ParametersUtil.getFieldValueFromInstance(instance, this.entity.id.name);
        parameterList.add(idValue);
        return parameterList;
    }

    @Override
    public String name() {
        return "\u6839\u636eID\u66f4\u65b0\u8bb0\u5f55";
    }

    private String generateUpdateByIdStatement(List<Property> propertyList) {
        StringBuilder builder = new StringBuilder();
        builder.append("update " + this.quickDAOConfig.databaseProvider.escape(this.entity.tableName) + " set ");
        for (Property property : propertyList) {
            if (property.id || property.createdAt) continue;
            builder.append(this.quickDAOConfig.databaseProvider.escape(property.column) + " = ?,");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(" where " + this.quickDAOConfig.databaseProvider.escape(this.entity.id.column) + " = ?");
        return builder.toString();
    }
}

