/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dml.instance;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;
import cn.schoolwow.quickdao.statement.dml.instance.AbstractDMLInstanceDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.instance.InsertInstanceBatchDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.instance.UpdateInstanceDatabaseStatement;
import java.util.ArrayList;

public class SaveInstanceDatabaseStatement
extends AbstractDMLInstanceDatabaseStatement {
    private Object[] instances;

    public SaveInstanceDatabaseStatement(Object[] instances, ManipulationOption option, QuickDAOConfig quickDAOConfig) {
        super(option, quickDAOConfig);
        this.instances = instances;
    }

    @Override
    public int executeUpdate() {
        ArrayList insertInstances = new ArrayList();
        ArrayList updateInstances = new ArrayList();
        Entity entity = this.quickDAOConfig.getEntityByClassName(this.instances[0].getClass().getName());
        if (entity.uniqueProperties.size() == 1) {
            Property uniqueProperty = entity.uniqueProperties.get(0);
            this.distinguishInstancesBySingleField(this.instances, entity.tableName, uniqueProperty, insertInstances, updateInstances);
        } else if (entity.uniqueProperties.size() > 1) {
            this.distinguishInstancesByMultipleField(this.instances, insertInstances, updateInstances);
        } else if (null != entity.id) {
            this.distinguishInstancesBySingleField(this.instances, entity.tableName, entity.id, insertInstances, updateInstances);
        }
        int effect = 0;
        if (!insertInstances.isEmpty()) {
            effect += new InsertInstanceBatchDatabaseStatement(insertInstances.toArray(new Object[0]), this.option, this.quickDAOConfig).executeUpdate();
        }
        if (!updateInstances.isEmpty()) {
            effect += new UpdateInstanceDatabaseStatement(updateInstances.toArray(new Object[0]), this.option, this.quickDAOConfig).executeUpdate();
        }
        return effect;
    }
}

