/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dml.instance;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;
import cn.schoolwow.quickdao.statement.dml.instance.AbstractDMLInstanceDatabaseStatement;
import cn.schoolwow.quickdao.util.ParametersUtil;
import java.util.ArrayList;
import java.util.List;

public class DeleteInstanceByUniqueKeyDatabaseStatement
extends AbstractDMLInstanceDatabaseStatement {
    private Entity entity;
    private Object[] instances;

    public DeleteInstanceByUniqueKeyDatabaseStatement(Object[] instances, ManipulationOption option, QuickDAOConfig quickDAOConfig) {
        super(option, quickDAOConfig);
        this.entity = quickDAOConfig.getEntityByClassName(instances[0].getClass().getName());
        this.instances = instances;
    }

    @Override
    public int executeUpdate() {
        return this.executeBatch(this.instances);
    }

    @Override
    public String getStatement() {
        String key = "deleteByUniqueKey_" + this.entity.tableName + "_" + this.quickDAOConfig.databaseProvider.name();
        if (!this.quickDAOConfig.statementCache.contains(key)) {
            String sql = this.generateDeleteByUniqueKeyStatement();
            this.quickDAOConfig.statementCache.put(key, sql);
        }
        return this.quickDAOConfig.statementCache.get(key);
    }

    @Override
    public List getParameters() {
        Object instance = this.instances[this.index];
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (Property property : this.entity.uniqueProperties) {
            Object value = ParametersUtil.getFieldValueFromInstance(instance, property.name);
            parameterList.add(value);
        }
        return parameterList;
    }

    @Override
    public String name() {
        return "\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u5220\u9664\u8bb0\u5f55";
    }

    private String generateDeleteByUniqueKeyStatement() {
        StringBuilder builder = new StringBuilder();
        builder.append("delete from " + this.quickDAOConfig.databaseProvider.escape(this.entity.tableName) + " where ");
        for (Property property : this.entity.uniqueProperties) {
            builder.append(this.quickDAOConfig.databaseProvider.escape(property.column) + " = " + (null == property.function ? "?" : property.function) + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }
}

