/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.statement.dml.instance;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;
import cn.schoolwow.quickdao.statement.dml.instance.AbstractDMLInstanceDatabaseStatement;
import cn.schoolwow.quickdao.util.ParametersUtil;
import java.util.Arrays;
import java.util.List;

public class DeleteInstanceByPropertyDatabaseStatement
extends AbstractDMLInstanceDatabaseStatement {
    private Entity entity;
    private Object[] instances;
    private Property property;

    public DeleteInstanceByPropertyDatabaseStatement(Object[] instances, Property property, ManipulationOption option, QuickDAOConfig quickDAOConfig) {
        super(option, quickDAOConfig);
        this.entity = quickDAOConfig.getEntityByClassName(instances[0].getClass().getName());
        this.instances = instances;
        this.property = property;
    }

    @Override
    public int executeUpdate() {
        return this.executeBatch(this.instances);
    }

    @Override
    public String getStatement() {
        String key = "deleteByProperty_" + this.entity.tableName + "_" + this.property.column + "_" + this.quickDAOConfig.databaseProvider.name();
        if (!this.quickDAOConfig.statementCache.contains(key)) {
            String sql = this.generateDeleteByPropertyStatement();
            this.quickDAOConfig.statementCache.put(key, sql);
        }
        return this.quickDAOConfig.statementCache.get(key);
    }

    @Override
    public List getParameters() {
        Object instance = this.instances[this.index];
        Object value = ParametersUtil.getFieldValueFromInstance(instance, this.property.name);
        return Arrays.asList(value);
    }

    @Override
    public String name() {
        return "\u6839\u636e\u6307\u5b9a\u5c5e\u6027\u5220\u9664\u8bb0\u5f55";
    }

    private String generateDeleteByPropertyStatement() {
        return "delete from " + this.quickDAOConfig.databaseProvider.escape(this.entity.tableName) + " where " + this.quickDAOConfig.databaseProvider.escape(this.property.column) + " = ?";
    }
}

