/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.domain.external.generator;

import cn.schoolwow.quickdao.domain.external.generator.IDGenerator;

public class SnowflakeIdGenerator
implements IDGenerator {
    private static final long twepoch = 1577808000000L;
    private static final long sequenceBits = 12L;
    private static final long timestampLeftShift = 12L;
    private static final long sequenceMask = 4095L;
    private static long lastTimestamp = -1L;
    private long sequence = 0L;

    @Override
    public synchronized String getNextId() {
        long timestamp = this.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException("\u65f6\u949f\u56de\u62e8!\u5f53\u524d\u65f6\u95f4\u6233:" + timestamp + ",\u4e0a\u6b21id\u65f6\u95f4\u6233:" + lastTimestamp);
        }
        if (lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        lastTimestamp = timestamp;
        long nextId = timestamp - 1577808000000L << 12 | this.sequence;
        return nextId + "";
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

