/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.dml;

import cn.schoolwow.quickdao.dao.dml.DatabaseManipulation;
import cn.schoolwow.quickdao.dao.sql.AbstractDatabaseDAO;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.ManipulationOption;
import cn.schoolwow.quickdao.statement.dml.DMLDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.instance.DeleteInstanceDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.instance.InsertIgnoreInstanceDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.instance.InsertInstanceBatchDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.instance.InsertInstanceDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.instance.SaveInstanceDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.instance.UpdateInstanceDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.json.DeleteJSONArrayDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.json.DeleteJSONObjectDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.json.InsertIgnoreJSONArrayDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.json.InsertIgnoreJSONObjectDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.json.InsertJSONArrayDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.json.InsertJSONObjectDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.json.UpdateJSONArrayDatabaseStatement;
import cn.schoolwow.quickdao.statement.dml.json.UpdateJSONObjectDatabaseStatement;
import cn.schoolwow.quickdao.util.ValidateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDatabaseManipulation
extends AbstractDatabaseDAO
implements DatabaseManipulation {
    private Logger logger = LoggerFactory.getLogger(AbstractDatabaseManipulation.class);
    private ManipulationOption option = new ManipulationOption();

    public AbstractDatabaseManipulation(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.option.connectionExecutor = this.connectionExecutor;
    }

    @Override
    public DatabaseManipulation returnGeneratedKeys(boolean returnGeneratedKeys) {
        this.option.returnGeneratedKeys = returnGeneratedKeys;
        return this;
    }

    @Override
    public DatabaseManipulation batch(boolean batch) {
        this.option.batch = batch;
        if (this.option.batch) {
            this.option.returnGeneratedKeys = false;
        }
        return this;
    }

    @Override
    public DatabaseManipulation perBatchCount(int perBatchCount) {
        this.option.perBatchCount = perBatchCount;
        return this;
    }

    @Override
    public DatabaseManipulation partColumn(String ... fieldNames) {
        this.option.partColumnSet.addAll(Arrays.asList(fieldNames));
        return this;
    }

    @Override
    public DatabaseManipulation uniqueFieldNames(String ... uniqueFieldNames) {
        this.option.uniqueFieldNames.addAll(Arrays.asList(uniqueFieldNames));
        return this;
    }

    @Override
    public int insert(String tableName, JSONObject instance) {
        return this.executeUpdate(new InsertJSONObjectDatabaseStatement(tableName, instance, this.option, this.quickDAOConfig));
    }

    @Override
    public int insert(String tableName, JSONArray instances) {
        return this.executeUpdate(new InsertJSONArrayDatabaseStatement(tableName, instances, this.option, this.quickDAOConfig));
    }

    @Override
    public int insertIgnore(String tableName, JSONObject instance) {
        ValidateUtil.checkUniqueFieldNames(this.option);
        return this.executeUpdate(new InsertIgnoreJSONObjectDatabaseStatement(tableName, instance, this.option, this.quickDAOConfig));
    }

    @Override
    public int insertIgnore(String tableName, JSONArray instances) {
        return this.executeUpdate(new InsertIgnoreJSONArrayDatabaseStatement(tableName, instances, this.option, this.quickDAOConfig));
    }

    @Override
    public int update(String tableName, JSONObject instance) {
        ValidateUtil.checkUniqueFieldNames(this.option);
        return this.executeUpdate(new UpdateJSONObjectDatabaseStatement(tableName, instance, this.option, this.quickDAOConfig));
    }

    @Override
    public int update(String tableName, JSONArray instances) {
        ValidateUtil.checkUniqueFieldNames(this.option);
        return this.executeUpdate(new UpdateJSONArrayDatabaseStatement(tableName, instances, this.option, this.quickDAOConfig));
    }

    @Override
    public int delete(String tableName, JSONObject instance) {
        ValidateUtil.checkUniqueFieldNames(this.option);
        return this.executeUpdate(new DeleteJSONObjectDatabaseStatement(tableName, instance, this.option, this.quickDAOConfig));
    }

    @Override
    public int delete(String tableName, JSONArray instances) {
        ValidateUtil.checkUniqueFieldNames(this.option);
        return this.executeUpdate(new DeleteJSONArrayDatabaseStatement(tableName, instances, this.option, this.quickDAOConfig));
    }

    @Override
    public int insert(Object instance) {
        if (null == instance) {
            return 0;
        }
        return this.insert(new Object[]{instance});
    }

    @Override
    public int insert(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        InsertInstanceDatabaseStatement databaseStatement = this.option.batch ? new InsertInstanceBatchDatabaseStatement(instances, this.option, this.quickDAOConfig) : new InsertInstanceDatabaseStatement(instances, this.option, this.quickDAOConfig);
        int effect = databaseStatement.executeUpdate();
        return effect;
    }

    @Override
    public int insert(Collection instanceCollection) {
        if (null == instanceCollection || instanceCollection.size() == 0) {
            return 0;
        }
        return this.insert(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int insertIgnore(Object instance) {
        if (null == instance || this.exist(instance)) {
            return 0;
        }
        return this.insert(instance);
    }

    @Override
    public int insertIgnore(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        return this.executeUpdate(new InsertIgnoreInstanceDatabaseStatement(instances, this.option, this.quickDAOConfig));
    }

    @Override
    public int insertIgnore(Collection instanceCollection) {
        return this.insertIgnore(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int update(Object instance) {
        if (null == instance) {
            return 0;
        }
        return this.update(new Object[]{instance});
    }

    @Override
    public int update(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        return this.executeUpdate(new UpdateInstanceDatabaseStatement(instances, this.option, this.quickDAOConfig));
    }

    @Override
    public int update(Collection instanceCollection) {
        if (null == instanceCollection || instanceCollection.size() == 0) {
            return 0;
        }
        return this.update(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int save(Object instance) {
        if (null == instance) {
            return 0;
        }
        if (this.exist(instance)) {
            return this.update(instance);
        }
        return this.insert(instance);
    }

    @Override
    public int save(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        return this.executeUpdate(new SaveInstanceDatabaseStatement(instances, this.option, this.quickDAOConfig));
    }

    @Override
    public int save(Collection instanceCollection) {
        if (null == instanceCollection || instanceCollection.size() == 0) {
            return 0;
        }
        return this.save(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int delete(Object instance) {
        if (null == instance) {
            return 0;
        }
        return this.delete(new Object[]{instance});
    }

    @Override
    public int delete(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        return this.executeUpdate(new DeleteInstanceDatabaseStatement(instances, this.option, this.quickDAOConfig));
    }

    @Override
    public int delete(Collection instanceCollection) {
        if (null == instanceCollection || instanceCollection.size() == 0) {
            return 0;
        }
        return this.delete(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int truncate(Class clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.truncate(entity.tableName);
    }

    @Override
    public int truncate(String tableName) {
        int effect = this.rawUpdate("truncate table " + this.quickDAOConfig.databaseProvider.escape(tableName), new Object[0]);
        return effect;
    }

    private int executeUpdate(DMLDatabaseStatement databaseStatement) {
        int effect = databaseStatement.executeUpdate();
        this.option.partColumnSet.clear();
        this.option.uniqueFieldNames.clear();
        return effect;
    }
}

