/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.ddl;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.dao.ddl.AbstractDatabaseDefinition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLiteDatabaseDefinition
extends AbstractDatabaseDefinition {
    private Logger logger = LoggerFactory.getLogger(SQLiteDatabaseDefinition.class);

    public SQLiteDatabaseDefinition(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public boolean hasTable(String tableName) {
        String hasTableSQL = "select name from sqlite_master where type = 'table' and name = ?;";
        return this.connectionExecutor.name("\u5224\u65ad\u8868\u662f\u5426\u5b58\u5728").sql(hasTableSQL).parameters(Arrays.asList(tableName)).executeAndCheckExists();
    }

    @Override
    public boolean hasColumn(String tableName, String columnName) {
        String hasTableColumnSQL = "select * from sqlite_master where name = ? and sql like ?";
        List<String> parameters = Arrays.asList(tableName, "%" + columnName + "%");
        return this.connectionExecutor.name("\u5224\u65ad\u8868\u6307\u5b9a\u5217\u662f\u5426\u5b58\u5728").sql(hasTableColumnSQL).parameters(parameters).executeAndCheckExists();
    }

    @Override
    public List<String> getTableNameList() {
        String getEntityListSQL = "select name from sqlite_master where type='table' and name != 'sqlite_sequence';";
        ArrayList<String> tableNames = new ArrayList<String>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u540d\u5217\u8868").sql(getEntityListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                tableNames.add(resultSet.getString("name"));
            }
        });
        return tableNames;
    }

    @Override
    public List<Entity> getDatabaseEntityList() {
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        String getEntityListSQL = "select name from sqlite_master where type='table' and name != 'sqlite_sequence';";
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5217\u8868").sql(getEntityListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                Entity entity = new Entity();
                entity.tableName = resultSet.getString("name");
                entity.properties = this.getPropertyList(entity.tableName);
                entityList.add(entity);
            }
        });
        this.getIndex(entityList);
        return entityList;
    }

    @Override
    public Entity getDatabaseEntity(String tableName) {
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        String getEntityListSQL = "select name from sqlite_master where type = 'table' and name = ?;";
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5217\u8868").sql(getEntityListSQL).parameters(Arrays.asList(tableName)).executeQuery(resultSet -> {
            while (resultSet.next()) {
                Entity entity = new Entity();
                entity.tableName = resultSet.getString("name");
                entity.properties = this.getPropertyList(tableName);
                entityList.add(entity);
            }
        });
        this.getIndex(entityList);
        if (entityList.isEmpty()) {
            return null;
        }
        return (Entity)entityList.get(0);
    }

    @Override
    public List<Property> getPropertyList(String tableName) {
        String getEntityPropertyListSQL = "PRAGMA table_info(`" + tableName + "`);";
        ArrayList<Property> propertyList = new ArrayList<Property>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5b57\u6bb5\u5217\u8868\u4fe1\u606f").sql(getEntityPropertyListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                Property property = new Property();
                this.getProperty((ResultSet)resultSet, property);
                propertyList.add(property);
            }
        });
        return propertyList;
    }

    @Override
    public Property getProperty(String tableName, String columnName) {
        List<Property> propertyList = this.getPropertyList(tableName);
        for (Property property : propertyList) {
            if (!property.column.equalsIgnoreCase(columnName)) continue;
            return property;
        }
        return null;
    }

    @Override
    public void create(Entity entity) {
        StringBuilder createTableBuilder = new StringBuilder();
        if (this.quickDAOConfig.databaseOption.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.size() > 0) {
            createTableBuilder.append("PRAGMA foreign_keys = ON;");
        }
        createTableBuilder.append("create table " + this.quickDAOConfig.databaseProvider.escape(entity.tableName) + "(");
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                createTableBuilder.append(this.getAutoIncrementSQL(property));
            } else {
                createTableBuilder.append(this.quickDAOConfig.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.length ? "" : "(" + property.length + ")"));
                if (property.notNull) {
                    createTableBuilder.append(" not null");
                }
                if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
                    createTableBuilder.append(" default " + property.defaultValue);
                }
                if (null != property.comment) {
                    createTableBuilder.append(" " + this.quickDAOConfig.databaseProvider.comment(property.comment));
                }
                if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                    createTableBuilder.append(" check " + property.escapeCheck);
                }
            }
            createTableBuilder.append(",");
        }
        if (this.quickDAOConfig.databaseOption.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.size() > 0) {
            for (Property property : entity.foreignKeyProperties) {
                createTableBuilder.append("foreign key(" + this.quickDAOConfig.databaseProvider.escape(property.column) + ") references ");
                String operation = property.foreignKey.foreignKeyOption().getOperation();
                createTableBuilder.append(this.quickDAOConfig.databaseProvider.escape(this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName) + "(" + this.quickDAOConfig.databaseProvider.escape(property.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation);
                createTableBuilder.append(",");
            }
        }
        createTableBuilder.deleteCharAt(createTableBuilder.length() - 1);
        createTableBuilder.append(")");
        if (null != entity.comment) {
            createTableBuilder.append(" " + this.quickDAOConfig.databaseProvider.comment(entity.comment));
        }
        createTableBuilder.append(";");
        for (IndexField indexField : entity.indexFieldList) {
            createTableBuilder.append(this.getCreateIndexStatement(indexField));
        }
        String createTableSQL = createTableBuilder.toString();
        this.connectionExecutor.name("\u751f\u6210\u65b0\u8868").sql(createTableSQL).executeUpdate();
        this.quickDAOConfig.getDatabaseEntityByTableName(entity.tableName);
    }

    @Override
    public void alterColumn(Property property) {
        throw new UnsupportedOperationException("SQLite\u6570\u636e\u4e0d\u652f\u6301\u4fee\u6539\u5217!");
    }

    @Override
    public Property dropColumn(String tableName, String columnName) {
        throw new UnsupportedOperationException("SQLite\u6570\u636e\u4e0d\u652f\u6301\u5220\u9664\u5217!");
    }

    @Override
    public boolean hasIndex(String tableName, String indexName) {
        String hasIndexSQL = "select name from sqlite_master where type = 'index' and name = ?;";
        return this.connectionExecutor.name("\u5224\u65ad\u7d22\u5f15\u662f\u5426\u5b58\u5728").sql(hasIndexSQL).parameters(Arrays.asList(indexName)).executeAndCheckExists();
    }

    @Override
    public List<IndexField> getIndexField(String tableName) {
        ArrayList<IndexField> indexFieldList = new ArrayList<IndexField>();
        String getIndexSQL = "select tbl_name, sql from sqlite_master where type='index' and sql is not null and tbl_name = ?;";
        this.connectionExecutor.name("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f").sql(getIndexSQL).parameters(Arrays.asList(tableName)).executeQuery(resultSet -> {
            while (resultSet.next()) {
                IndexField indexField = this.getIndexField((ResultSet)resultSet);
                if (null == indexField) continue;
                indexFieldList.add(indexField);
            }
        });
        return indexFieldList;
    }

    @Override
    public void enableForeignConstraintCheck(boolean enable) {
        String foreignConstraintCheckSQL = "PRAGMA foreign_keys = " + enable + ";";
        this.connectionExecutor.name(enable ? "\u542f\u7528\u5916\u952e\u7ea6\u675f\u68c0\u67e5" : "\u7981\u7528\u5916\u952e\u7ea6\u675f\u68c0\u67e5").sql(foreignConstraintCheckSQL).executeUpdate();
    }

    @Override
    protected String getAutoIncrementSQL(Property property) {
        return property.column + " " + property.columnType + (null == property.length ? "" : "(" + property.length + ")") + " primary key autoincrement";
    }

    @Override
    protected void getIndex(List<Entity> entityList) {
        String getIndexSQL = "select tbl_name, sql from sqlite_master where type='index' and sql is not null;";
        this.connectionExecutor.name("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f").sql(getIndexSQL).executeQuery(resultSet -> {
            block0: while (resultSet.next()) {
                for (Entity entity : entityList) {
                    if (!entity.tableName.equalsIgnoreCase(resultSet.getString("tbl_name"))) continue;
                    IndexField indexField = this.getIndexField((ResultSet)resultSet);
                    if (null == indexField) continue block0;
                    entity.indexFieldList.add(indexField);
                    continue block0;
                }
            }
        });
    }

    private void getProperty(ResultSet resultSet, Property property) throws SQLException {
        property.column = resultSet.getString("name");
        property.columnType = resultSet.getString("type");
        if (property.columnType.contains("(") && property.columnType.contains(")")) {
            String lengthString = property.columnType.substring(property.columnType.indexOf("(") + 1, property.columnType.indexOf(")"));
            if (lengthString.matches("\\d+")) {
                property.length = Integer.parseInt(lengthString);
            }
            property.columnType = property.columnType.substring(0, property.columnType.indexOf("("));
        }
        property.notNull = "1".equals(resultSet.getString("notnull"));
        if (null != resultSet.getString("dflt_value")) {
            property.defaultValue = resultSet.getString("dflt_value");
        }
        if (1 == resultSet.getInt("pk")) {
            property.id = true;
            property.strategy = IdStrategy.AutoIncrement;
        }
    }

    private IndexField getIndexField(ResultSet resultSet) throws SQLException {
        String sql = resultSet.getString("sql");
        if (!sql.contains("\"") && !sql.contains("`")) {
            this.logger.warn("SQLite\u83b7\u53d6\u7d22\u5f15,\u7d22\u5f15\u4e0d\u5305\u542b\"\u4e5f\u4e0d\u5305\u542b`,\u8df3\u8fc7\u83b7\u53d6,\u539f\u59cb\u7d22\u5f15\u5b57\u7b26\u4e32:{}", (Object)sql);
            return null;
        }
        String[] tokens = sql.split("[\"|`]");
        IndexField indexField = new IndexField();
        indexField.indexType = tokens[0].contains("UNIQUE") ? IndexType.UNIQUE : IndexType.NORMAL;
        indexField.indexName = tokens[1];
        indexField.tableName = tokens[3];
        for (int i = 5; i < tokens.length - 1; ++i) {
            indexField.columns.add(tokens[i]);
        }
        return indexField;
    }

    private String getCreateTableStatement(Entity entity) {
        StringBuilder builder = new StringBuilder();
        if (this.quickDAOConfig.databaseOption.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.size() > 0) {
            builder.append("PRAGMA foreign_keys = ON;");
        }
        builder.append("create table " + this.quickDAOConfig.databaseProvider.escape(entity.tableName) + "(");
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                builder.append(this.getAutoIncrementSQL(property));
            } else {
                builder.append(this.quickDAOConfig.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.length ? "" : "(" + property.length + ")"));
                if (property.notNull) {
                    builder.append(" not null");
                }
                if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
                    builder.append(" default " + property.defaultValue);
                }
                if (null != property.comment) {
                    builder.append(" " + this.quickDAOConfig.databaseProvider.comment(property.comment));
                }
                if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                    builder.append(" check " + property.escapeCheck);
                }
            }
            builder.append(",");
        }
        if (this.quickDAOConfig.databaseOption.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.size() > 0) {
            for (Property property : entity.foreignKeyProperties) {
                builder.append("foreign key(" + this.quickDAOConfig.databaseProvider.escape(property.column) + ") references ");
                String operation = property.foreignKey.foreignKeyOption().getOperation();
                builder.append(this.quickDAOConfig.databaseProvider.escape(this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName) + "(" + this.quickDAOConfig.databaseProvider.escape(property.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation);
                builder.append(",");
            }
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        if (null != entity.comment) {
            builder.append(" " + this.quickDAOConfig.databaseProvider.comment(entity.comment));
        }
        builder.append(";");
        for (IndexField indexField : entity.indexFieldList) {
            builder.append(this.getCreateIndexStatement(indexField));
        }
        return builder.toString();
    }
}

