/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.ddl;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.dao.ddl.DatabaseDefinition;
import cn.schoolwow.quickdao.dao.sql.AbstractDatabaseDAO;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseDefinition
extends AbstractDatabaseDAO
implements DatabaseDefinition {
    protected Logger logger = LoggerFactory.getLogger(AbstractDatabaseDefinition.class);

    public AbstractDatabaseDefinition(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public boolean hasTable(Class clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.hasTable(entity.tableName);
    }

    @Override
    public boolean hasTable(String tableName) {
        throw new UnsupportedOperationException("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u5224\u65ad\u8868\u662f\u5426\u5b58\u5728!");
    }

    @Override
    public boolean hasColumn(String tableName, String columnName) {
        throw new UnsupportedOperationException("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u5224\u65ad\u8868\u7684\u6307\u5b9a\u5217\u662f\u5426\u5b58\u5728!");
    }

    @Override
    public List<String> getTableNameList() {
        throw new UnsupportedOperationException("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u83b7\u53d6\u6240\u6709\u8868\u540d\u4fe1\u606f!");
    }

    @Override
    public List<Entity> getDatabaseEntityList() {
        throw new UnsupportedOperationException("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u83b7\u53d6\u8868\u4fe1\u606f!");
    }

    @Override
    public Entity getDatabaseEntity(String tableName) {
        throw new UnsupportedOperationException("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u83b7\u53d6\u6307\u5b9a\u8868\u4fe1\u606f!");
    }

    @Override
    public List<Property> getPropertyList(Class clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.getPropertyList(entity.tableName);
    }

    @Override
    public List<Property> getPropertyList(String tableName) {
        throw new UnsupportedOperationException("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u83b7\u53d6\u8868\u5b57\u6bb5\u5217\u8868\u4fe1\u606f!");
    }

    @Override
    public Property getProperty(Class clazz, String columnName) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.getProperty(entity.tableName, columnName);
    }

    @Override
    public Property getProperty(String tableName, String columnName) {
        throw new UnsupportedOperationException("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u83b7\u53d6\u8868\u6307\u5b9a\u5b57\u6bb5\u4fe1\u606f!");
    }

    @Override
    public void create(Class clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        this.create(entity);
    }

    @Override
    public void create(Entity entity) {
        throw new UnsupportedOperationException("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u521b\u5efa\u8868\u64cd\u4f5c!");
    }

    @Override
    public void dropTable(Class clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        this.dropTable(entity.tableName);
    }

    @Override
    public void dropTable(String tableName) {
        String dropTableSQL = "drop table " + this.quickDAOConfig.databaseProvider.escape(tableName) + ";";
        this.connectionExecutor.name("\u5220\u9664\u8868").sql(dropTableSQL).executeUpdate();
        this.quickDAOConfig.deleteDatabaseEntityCache(tableName);
    }

    @Override
    public void rebuild(Class clazz) {
        if (this.hasTable(clazz)) {
            this.dropTable(clazz);
        }
        this.create(clazz);
    }

    @Override
    public void rebuild(String tableName) {
        if (this.hasTable(tableName)) {
            this.dropTable(tableName);
        }
        Entity entity = this.quickDAOConfig.getDatabaseEntityByTableName(tableName);
        this.create(entity);
    }

    @Override
    public Property createColumn(String tableName, Property property) {
        Entity entity = this.quickDAOConfig.getDatabaseEntityByTableName(tableName);
        entity.tableName = tableName;
        property.entity = entity;
        if (null != property.check) {
            if (!property.check.isEmpty() && !property.check.contains("(")) {
                property.check = "(" + property.check + ")";
            }
            property.check = property.check.replace("#{" + property.name + "}", property.column);
            property.escapeCheck = property.check.replace(property.column, this.quickDAOConfig.databaseProvider.escape(property.column));
        }
        StringBuilder createColumnBuilder = new StringBuilder("alter table " + this.quickDAOConfig.databaseProvider.escape(tableName) + " add ");
        if (property.id && property.strategy == IdStrategy.AutoIncrement) {
            createColumnBuilder.append(this.getAutoIncrementSQL(property));
        } else {
            createColumnBuilder.append(this.quickDAOConfig.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.length ? "" : "(" + property.length + ")"));
            if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
                createColumnBuilder.append(" default " + property.defaultValue);
            }
            if (property.notNull) {
                createColumnBuilder.append(" not null");
            }
            if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                createColumnBuilder.append(" check " + property.escapeCheck);
            }
            if (null != property.comment && !"sqlite".equalsIgnoreCase(this.quickDAOConfig.databaseProvider.name())) {
                createColumnBuilder.append(" " + this.quickDAOConfig.databaseProvider.comment(property.comment));
            }
        }
        String createPropertySQL = createColumnBuilder.toString();
        this.connectionExecutor.name("\u65b0\u589e\u5217").sql(createPropertySQL).executeUpdate();
        this.quickDAOConfig.deleteDatabaseEntityCache(tableName);
        return property;
    }

    @Override
    public void alterColumn(Property property) {
        StringBuilder alterColumnBuilder = new StringBuilder("alter table " + this.quickDAOConfig.databaseProvider.escape(property.entity.tableName));
        if ("sqlserver".equalsIgnoreCase(this.quickDAOConfig.databaseProvider.name())) {
            alterColumnBuilder.append(" alter");
        } else {
            alterColumnBuilder.append(" modify");
        }
        alterColumnBuilder.append(" column " + this.quickDAOConfig.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.length ? "" : "(" + property.length + ")"));
        if (property.notNull) {
            alterColumnBuilder.append(" not null");
        }
        if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
            alterColumnBuilder.append(" default " + property.defaultValue);
        }
        if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
            alterColumnBuilder.append(" check " + property.escapeCheck);
        }
        if (null != property.comment) {
            alterColumnBuilder.append(" " + this.quickDAOConfig.databaseProvider.comment(property.comment));
        }
        alterColumnBuilder.append(";");
        String alterColumnSQL = alterColumnBuilder.toString();
        this.connectionExecutor.name("\u4fee\u6539\u5217").sql(alterColumnSQL).executeUpdate();
        this.quickDAOConfig.deleteDatabaseEntityCache(property.entity.tableName);
    }

    @Override
    public Property dropColumn(String tableName, String columnName) {
        Property deletedProperty = this.getProperty(tableName, columnName);
        if (null == deletedProperty) {
            throw new IllegalArgumentException("\u88ab\u5220\u9664\u7684\u5217\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName + ",\u5217\u540d:" + columnName);
        }
        deletedProperty.entity = this.getDatabaseEntity(tableName);
        String dropColumnSQL = "alter table " + this.quickDAOConfig.databaseProvider.escape(tableName) + " drop column " + this.quickDAOConfig.databaseProvider.escape(columnName) + ";";
        this.connectionExecutor.name("\u5220\u9664\u5217").sql(dropColumnSQL).executeUpdate();
        this.quickDAOConfig.deleteDatabaseEntityCache(tableName);
        return deletedProperty;
    }

    @Override
    public boolean hasIndex(String tableName, String indexName) {
        throw new UnsupportedOperationException("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u5224\u65ad\u8868\u7d22\u5f15\u662f\u5426\u5b58\u5728!");
    }

    @Override
    public boolean hasConstraint(String tableName, String constraintName) {
        String hasConstraintExistsSQL = "select constraint_name from information_schema.KEY_COLUMN_USAGE where constraint_name='" + constraintName + "';";
        return this.connectionExecutor.name("\u5224\u65ad\u7ea6\u675f\u662f\u5426\u5b58\u5728").sql(hasConstraintExistsSQL).executeAndCheckExists();
    }

    @Override
    public List<IndexField> getIndexField(String tableName) {
        throw new UnsupportedOperationException("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u83b7\u53d6\u8868\u7d22\u5f15\u4fe1\u606f!");
    }

    @Override
    public void createIndex(IndexField indexField) {
        String createIndexSQL = this.getCreateIndexStatement(indexField);
        this.connectionExecutor.name("\u521b\u5efa\u7d22\u5f15").sql(createIndexSQL).executeUpdate();
    }

    @Override
    public void dropIndex(String tableName, String indexName) {
        String dropIndexSQL = "drop index " + this.quickDAOConfig.databaseProvider.escape(indexName) + ";";
        this.connectionExecutor.name("\u5220\u9664\u7d22\u5f15").sql(dropIndexSQL).executeUpdate();
        this.quickDAOConfig.deleteDatabaseEntityCache(tableName);
    }

    @Override
    public void createForeignKey(Property property) {
        String operation = property.foreignKey.foreignKeyOption().getOperation();
        String reference = this.quickDAOConfig.databaseProvider.escape(this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName) + "(" + this.quickDAOConfig.databaseProvider.escape(property.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation;
        String foreignKeyName = "FK_" + property.entity.tableName + "_" + property.foreignKey.field() + "_" + this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName + "_" + property.name;
        String createForeignKeySQL = "alter table " + this.quickDAOConfig.databaseProvider.escape(property.entity.tableName) + " add constraint " + this.quickDAOConfig.databaseProvider.escape(foreignKeyName) + " foreign key(" + this.quickDAOConfig.databaseProvider.escape(property.column) + ") references " + reference + ";";
        if (this.hasConstraint(property.entity.tableName, foreignKeyName)) {
            this.logger.warn("\u5916\u952e\u7ea6\u675f\u5df2\u5b58\u5728,\u8868\u540d:{},\u5916\u952e\u7ea6\u675f\u540d:{}", (Object)property.entity.tableName, (Object)foreignKeyName);
            return;
        }
        this.connectionExecutor.name("\u521b\u5efa\u5916\u952e").sql(createForeignKeySQL).executeUpdate();
        this.quickDAOConfig.deleteDatabaseEntityCache(property.entity.tableName);
    }

    @Override
    public void enableForeignConstraintCheck(boolean enable) {
        this.logger.warn("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u5f00\u542f/\u5173\u95ed\u5916\u952e\u7ea6\u675f!");
    }

    protected abstract String getAutoIncrementSQL(Property var1);

    protected abstract void getIndex(List<Entity> var1);

    protected String getCreateIndexStatement(IndexField indexField) {
        StringBuilder createIndexBuilder = new StringBuilder("create");
        switch (indexField.indexType) {
            case NORMAL: {
                break;
            }
            case UNIQUE: {
                createIndexBuilder.append(" unique");
                break;
            }
            case FULLTEXT: {
                createIndexBuilder.append(" fulltext");
            }
        }
        if (null == indexField.indexName || indexField.indexName.isEmpty()) {
            StringBuilder indexNameBuilder = new StringBuilder(indexField.tableName + "_" + indexField.indexType.name().toLowerCase() + "_");
            for (String column : indexField.columns) {
                indexNameBuilder.append(column + ",");
            }
            indexNameBuilder.deleteCharAt(indexNameBuilder.length() - 1);
            indexField.indexName = indexNameBuilder.toString();
        }
        createIndexBuilder.append(" index " + this.quickDAOConfig.databaseProvider.escape(indexField.indexName) + " on " + this.quickDAOConfig.databaseProvider.escape(indexField.tableName) + "(");
        for (String column : indexField.columns) {
            createIndexBuilder.append(this.quickDAOConfig.databaseProvider.escape(column) + ",");
        }
        createIndexBuilder.deleteCharAt(createIndexBuilder.length() - 1);
        createIndexBuilder.append(")");
        if (null != indexField.using && !indexField.using.isEmpty()) {
            createIndexBuilder.append(" using " + indexField.using);
        }
        if (null != indexField.comment && !indexField.comment.isEmpty()) {
            createIndexBuilder.append(" " + this.quickDAOConfig.databaseProvider.comment(indexField.comment));
        }
        createIndexBuilder.append(";");
        return createIndexBuilder.toString();
    }
}

