/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao;

import cn.schoolwow.quickdao.dao.ConnectionExecutor;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.StatementListener;
import cn.schoolwow.quickdao.domain.internal.ThrowingConsumer;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import cn.schoolwow.quickdao.util.ParametersUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionExecutorImpl
implements ConnectionExecutor {
    private Logger logger = LoggerFactory.getLogger(ConnectionExecutor.class);
    private DataSource dataSource;
    private Connection transactionConnection;
    private PreparedStatement batchPrepareStatement;
    private String databaseName;
    private QuickDAOConfig quickDAOConfig;
    private boolean returnGeneratedKeys;
    private String name;
    private String sql;
    private List parameters;
    private String generatedKeys;

    public ConnectionExecutorImpl(QuickDAOConfig quickDAOConfig) {
        this.dataSource = quickDAOConfig.dataSource;
        this.databaseName = quickDAOConfig.databaseProvider.name();
        this.quickDAOConfig = quickDAOConfig;
    }

    @Override
    public ConnectionExecutor name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ConnectionExecutor sql(String sql) {
        this.sql = sql;
        return this;
    }

    @Override
    public ConnectionExecutor returnGeneratedKeys(boolean returnGeneratedKeys) {
        this.returnGeneratedKeys = returnGeneratedKeys;
        return this;
    }

    @Override
    public ConnectionExecutor parameters(List parameters) {
        if (null == parameters || parameters.size() == 0) {
            return this;
        }
        this.parameters = parameters;
        return this;
    }

    @Override
    public ConnectionExecutor batchParameters(List parameters) {
        if (null == this.batchPrepareStatement) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528startBatch\u65b9\u6cd5!");
        }
        String formatSQL = ParametersUtil.replaceStatementPlaceholder(this.sql, parameters);
        try {
            ParametersUtil.setPrepareStatementParameter(this.batchPrepareStatement, parameters, this.databaseName);
            this.batchPrepareStatement.addBatch();
            this.logger.debug("[\u66f4\u65b0-\u9884\u5904\u7406],\u540d\u79f0:{}, \u6267\u884c\u8bed\u53e5:{}", (Object)this.name, (Object)formatSQL);
        }
        catch (SQLException e) {
            this.logger.warn("\u6dfb\u52a0\u6279\u5904\u7406SQL\u8bed\u53e5\u5931\u8d25,\u540d\u79f0:{},\u539f\u59cbSQL:{}", (Object)this.name, (Object)formatSQL);
            try {
                this.batchPrepareStatement.close();
            }
            catch (SQLException ex) {
                this.logger.error("\u5173\u95ed\u6279\u5904\u7406\u8bed\u53e5\u5f02\u5e38", (Throwable)ex);
            }
            throw new SQLRuntimeException(e);
        }
        return this;
    }

    @Override
    public ConnectionExecutor startTransaction() {
        try {
            this.transactionConnection = this.dataSource.getConnection();
            this.transactionConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return this;
    }

    @Override
    public void setTransactionIsolation(int transactionIsolation) {
        try {
            this.transactionConnection.setTransactionIsolation(transactionIsolation);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public Savepoint setSavePoint(String name) {
        try {
            Savepoint savepoint = this.transactionConnection.setSavepoint(name);
            return savepoint;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void rollback() {
        try {
            this.transactionConnection.rollback();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void rollback(Savepoint savePoint) {
        try {
            this.transactionConnection.rollback(savePoint);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void commit() {
        try {
            this.transactionConnection.commit();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public boolean executeAndCheckExists() {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        this.executeQuery(resultSet -> {
            if (resultSet.next()) {
                atomicBoolean.set(true);
            } else {
                atomicBoolean.set(false);
            }
        });
        return atomicBoolean.get();
    }

    @Override
    public void executeQuery(ThrowingConsumer<ResultSet> resultSetThrowingConsumer) {
        this.beforeExecute();
        long startTime = System.currentTimeMillis();
        String formatSQL = ParametersUtil.replaceStatementPlaceholder(this.sql, this.parameters);
        if (this.quickDAOConfig.record) {
            this.quickDAOConfig.sqlRecordBuilder.append(formatSQL + "\r\n");
            return;
        }
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sql);){
            ParametersUtil.setPrepareStatementParameter(preparedStatement, this.parameters, this.databaseName);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                long endTime = System.currentTimeMillis();
                this.logger.debug("[\u67e5\u8be2]\u540d\u79f0:{},\u8017\u65f6:{}ms,\u6267\u884c\u8bed\u53e5:{}", new Object[]{this.name, endTime - startTime, formatSQL});
                resultSetThrowingConsumer.accept(resultSet);
            }
        }
        catch (SQLException e) {
            this.logger.warn("SQL\u8bed\u53e5\u6267\u884c\u5931\u8d25,\u540d\u79f0:{},\u539f\u59cbSQL:{}", (Object)this.name, (Object)formatSQL);
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public int executeUpdate() {
        this.beforeExecute();
        String formatSQL = ParametersUtil.replaceStatementPlaceholder(this.sql, this.parameters);
        if (this.quickDAOConfig.record) {
            this.quickDAOConfig.sqlRecordBuilder.append(formatSQL + "\r\n");
            return 0;
        }
        long startTime = System.currentTimeMillis();
        String executeSQL = this.sql;
        int indexOfSemicolon = this.sql.indexOf(";");
        try {
            int effect = 0;
            if (indexOfSemicolon >= 0 && indexOfSemicolon != this.sql.length() - 1) {
                StringTokenizer st = new StringTokenizer(this.sql, ";");
                while (st.hasMoreTokens()) {
                    executeSQL = st.nextToken();
                    effect += this.doExecuteUpdate(executeSQL, null);
                }
            } else {
                effect = this.doExecuteUpdate(executeSQL, this.parameters);
            }
            long endTime = System.currentTimeMillis();
            this.logger.debug("[\u66f4\u65b0]\u540d\u79f0:{},\u8017\u65f6:{}ms,\u5f71\u54cd\u884c\u6570:{},\u6267\u884c\u8bed\u53e5:{}", new Object[]{this.name, endTime - startTime, effect, formatSQL});
            return effect;
        }
        catch (SQLException e) {
            this.logger.warn("SQL\u8bed\u53e5\u6267\u884c\u5931\u8d25,\u540d\u79f0:{},\u539f\u59cbSQL:{}", (Object)this.name, (Object)executeSQL);
            if (indexOfSemicolon >= 0 && indexOfSemicolon != this.sql.length() - 1) {
                formatSQL = formatSQL.replace(";", ";\r\n");
                this.logger.warn("SQL\u8bed\u53e5\u6267\u884c\u5931\u8d25,\u540d\u79f0:{},\u5b8c\u6574\u6267\u884cSQL:\n{}", (Object)this.name, (Object)formatSQL);
            }
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public ConnectionExecutor startBatch() {
        try {
            this.batchPrepareStatement = null == this.transactionConnection ? this.dataSource.getConnection().prepareStatement(this.sql) : this.transactionConnection.prepareStatement(this.sql);
        }
        catch (SQLException e) {
            this.logger.warn("SQL\u8bed\u53e5\u6267\u884c\u5931\u8d25,\u540d\u79f0:{},\u539f\u59cbSQL:{}", (Object)this.name, (Object)this.sql);
            throw new SQLRuntimeException(e);
        }
        return this;
    }

    @Override
    public int executeBatch() {
        try {
            int[] batches;
            int effect = 0;
            block6: for (int batch : batches = this.batchPrepareStatement.executeBatch()) {
                switch (batch) {
                    case -2: {
                        ++effect;
                        continue block6;
                    }
                    case -3: {
                        continue block6;
                    }
                    default: {
                        effect += batch;
                    }
                }
            }
            return effect;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public ConnectionExecutor clearBatch() {
        if (null != this.batchPrepareStatement) {
            try {
                this.batchPrepareStatement.clearBatch();
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
        }
        return this;
    }

    @Override
    public ConnectionExecutor closeBatch() {
        try {
            if (null != this.batchPrepareStatement) {
                this.batchPrepareStatement.close();
                if (null == this.transactionConnection) {
                    this.batchPrepareStatement.getConnection().close();
                }
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return this;
    }

    @Override
    public String getGeneratedKeys() {
        return this.generatedKeys;
    }

    @Override
    public void close() {
        this.closeBatch();
        try {
            if (null != this.transactionConnection) {
                this.transactionConnection.close();
                this.transactionConnection = null;
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    private void beforeExecute() {
        if (!this.sql.contains("?") && null != this.parameters && !this.parameters.isEmpty()) {
            this.parameters = null;
        }
        for (StatementListener statementListener : this.quickDAOConfig.databaseOption.statementListener) {
            String userSQL = statementListener.beforeExecute(this.name, this.sql, this.parameters);
            if (null == userSQL || userSQL.isEmpty()) continue;
            this.sql = userSQL;
        }
    }

    /*
     * Loose catch block
     */
    private int doExecuteUpdate(String sql, Collection parameters) throws SQLException {
        Connection connection = this.transactionConnection;
        if (null == connection) {
            connection = this.dataSource.getConnection();
        }
        try {
            try (PreparedStatement preparedStatement = this.returnGeneratedKeys ? connection.prepareStatement(sql, 1) : connection.prepareStatement(sql);){
                ParametersUtil.setPrepareStatementParameter(preparedStatement, parameters, this.databaseName);
                int effect = preparedStatement.executeUpdate();
                if (this.returnGeneratedKeys && !"oracle".equalsIgnoreCase(this.databaseName)) {
                    try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
                        if (resultSet.next()) {
                            this.generatedKeys = resultSet.getString(1);
                        }
                    }
                }
                int n = effect;
                return n;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (null == this.transactionConnection) {
                connection.close();
            }
        }
    }
}

