/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.util.GenerateEntityFileOption;
import cn.schoolwow.quickdao.domain.external.util.SynchronizeTableStructureOption;
import cn.schoolwow.quickdao.domain.internal.DatabaseUpgrade;
import cn.schoolwow.quickdao.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAOUtils {
    private static Logger logger = LoggerFactory.getLogger(DAOUtils.class);

    public static void databaseUpgrade(DAO dao, String comment, Consumer<DAO> daoConsumer) {
        DatabaseUpgrade databaseUpgrade = dao.fetch(DatabaseUpgrade.class, "comment", (Object)comment);
        if (null != databaseUpgrade) {
            if (!databaseUpgrade.isSuccess()) {
                DAOUtils.executeDatabaseUpgrade(dao, databaseUpgrade);
            }
            return;
        }
        databaseUpgrade = new DatabaseUpgrade();
        databaseUpgrade.setComment(comment);
        dao.startRecord();
        daoConsumer.accept(dao);
        String sql = dao.stopRecord();
        databaseUpgrade.setSql(sql);
        dao.insert(databaseUpgrade);
        DAOUtils.executeDatabaseUpgrade(dao, databaseUpgrade);
    }

    public static void generateEntityFile(GenerateEntityFileOption generateEntityFileOption) {
        DAO dao = generateEntityFileOption.dao;
        QuickDAOConfig quickDAOConfig = dao.getQuickDAOConfig();
        if (quickDAOConfig.entityOption.packageNameMap.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528packageName\u65b9\u6cd5\u6307\u5b9a\u5305\u540d");
        }
        ArrayList<Entity> databaseEntityList = new ArrayList<Entity>();
        if (null != generateEntityFileOption.tableNames) {
            for (String tableName : generateEntityFileOption.tableNames) {
                databaseEntityList.add(dao.getDatabaseEntity(tableName));
            }
        } else {
            databaseEntityList.addAll(dao.getDatabaseEntityList());
        }
        StringBuilder builder = new StringBuilder();
        String packageName = quickDAOConfig.entityOption.packageNameMap.keySet().iterator().next();
        Set<Map.Entry<String, String>> typeFieldMappingEntrySet = quickDAOConfig.databaseProvider.getTypeFieldMapping().entrySet();
        for (Entity databaseEntity : databaseEntityList) {
            File targetFile;
            String newEntityClassName;
            String entityClassName = StringUtil.underline2Camel(databaseEntity.tableName);
            entityClassName = entityClassName.toUpperCase().charAt(0) + entityClassName.substring(1);
            if (null != generateEntityFileOption.entityClassNameMapping && null != (newEntityClassName = generateEntityFileOption.entityClassNameMapping.apply(databaseEntity, entityClassName)) && !newEntityClassName.isEmpty()) {
                entityClassName = newEntityClassName;
            }
            if (!(targetFile = new File(generateEntityFileOption.sourceClassPath + "/" + packageName.replace(".", "/") + "/" + entityClassName.replace(".", "/") + ".java")).getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                logger.warn("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25,\u6587\u4ef6\u5939\u8def\u5f84:{}", (Object)targetFile.getParent());
                continue;
            }
            logger.debug("\u51c6\u5907\u751f\u6210\u6587\u4ef6!\u8868\u540d:{}, \u6587\u4ef6\u540d:{}", (Object)databaseEntity.tableName, (Object)targetFile);
            builder.setLength(0);
            builder.append("package " + packageName + (entityClassName.contains(".") ? "." + entityClassName.substring(0, entityClassName.lastIndexOf(".")) : "") + ";\n");
            builder.append("import cn.schoolwow.quickdao.annotation.*;\n\n");
            if (null != databaseEntity.comment) {
                builder.append("@Comment(\"" + databaseEntity.comment + "\")\n");
            }
            if (null != databaseEntity.tableName) {
                builder.append("@TableName(\"" + databaseEntity.tableName + "\")\n");
            }
            builder.append("public class " + (entityClassName.contains(".") ? entityClassName.substring(entityClassName.lastIndexOf(".") + 1) : entityClassName) + "{\n\n");
            for (Property property : databaseEntity.properties) {
                if (null != property.comment && !property.comment.isEmpty()) {
                    property.comment = property.comment.replaceAll("\r", "\\n").replaceAll("\n", "\\n").replaceAll("\r\n", "\\n");
                    builder.append("\t@Comment(\"" + property.comment + "\")\n");
                }
                if (property.id) {
                    builder.append("\t@Id");
                    if (!IdStrategy.AutoIncrement.equals((Object)property.strategy)) {
                        builder.append("(strategy = IdStrategy.None)");
                    }
                    builder.append("\n");
                }
                builder.append("\t@ColumnName(\"" + property.column + "\")\n");
                builder.append("\t@ColumnType(\"" + property.columnType + (null == property.length ? "" : "(" + property.length + ")") + "\")\n");
                if (null != generateEntityFileOption.columnFieldTypeMapping) {
                    property.className = generateEntityFileOption.columnFieldTypeMapping.apply(property.columnType);
                }
                if (null == property.className) {
                    for (Map.Entry<String, String> entry : typeFieldMappingEntrySet) {
                        if (!entry.getValue().contains(property.columnType.toUpperCase())) continue;
                        property.className = entry.getKey().replace("java.lang.", "");
                        break;
                    }
                }
                if (null == property.className) {
                    logger.warn("\u5b57\u6bb5\u7c7b\u578b\u5339\u914d\u5931\u8d25,\u8868\u540d:{}\u5b57\u6bb5\u540d\u79f0:{},\u7c7b\u578b:{}", new Object[]{databaseEntity.tableName, property.column, property.columnType});
                    property.className = "{{" + property.columnType + "}}";
                }
                if (null == property.name || property.name.isEmpty()) {
                    property.name = StringUtil.underline2Camel(property.column);
                }
                builder.append("\tprivate " + property.className + " " + property.name + ";\n\n");
            }
            for (Property property : databaseEntity.properties) {
                builder.append("\tpublic " + property.className + " get" + StringUtil.firstLetterUpper(property.name) + "(){\n\t\treturn this." + property.name + ";\n\t}\n\n");
                builder.append("\tpublic void set" + StringUtil.firstLetterUpper(property.name) + "(" + property.className + " " + property.name + "){\n\t\tthis." + property.name + " = " + property.name + ";\n\t}\n\n");
            }
            builder.append("\t@Override\n\tpublic String toString() {\n\t\treturn \"\\n{\\n\" +\n");
            for (Property property : databaseEntity.properties) {
                builder.append("\t\t\t\"" + (null == property.comment ? property.column : property.comment) + ":\" + " + property.name + " + \"\\n\" +\n");
            }
            builder.replace(builder.length() - 3, builder.length(), ";");
            builder.append("\t}\n");
            builder.append("};");
            if (targetFile.exists() && !targetFile.delete()) {
                logger.warn("\u5220\u9664\u6587\u4ef6\u5931\u8d25,\u6587\u4ef6\u8def\u5f84:{}", (Object)targetFile.getAbsolutePath());
                continue;
            }
            try {
                Files.write(targetFile.toPath(), builder.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                logger.error("\u5b9e\u4f53\u7c7b\u6587\u4ef6\u5199\u5165\u5931\u8d25", (Throwable)e);
            }
        }
        logger.info("\u5b9e\u4f53\u7c7b\u6587\u4ef6\u751f\u6210\u5b8c\u6bd5!\u6587\u4ef6\u5939:{}", (Object)(generateEntityFileOption.sourceClassPath + "/" + packageName.replace(".", "/")));
    }

    public static void synchronizeTableStructure(SynchronizeTableStructureOption synchronizeTableStructureOption) {
        if (null == synchronizeTableStructureOption.source) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u8fc1\u79fb\u6e90\u6570\u636e\u5e93!");
        }
        if (null == synchronizeTableStructureOption.target) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u8fc1\u79fb\u76ee\u6807\u6570\u636e\u5e93!");
        }
        List<Object> sourceEntityList = new ArrayList();
        if (null == synchronizeTableStructureOption.tableNames || synchronizeTableStructureOption.tableNames.length == 0) {
            sourceEntityList = synchronizeTableStructureOption.source.getDatabaseEntityList();
        } else {
            for (String tableName : synchronizeTableStructureOption.tableNames) {
                Entity entity = synchronizeTableStructureOption.source.getDatabaseEntity(tableName);
                if (null == entity) {
                    logger.warn("\u6570\u636e\u5e93\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
                    continue;
                }
                sourceEntityList.add(entity);
            }
        }
        ArrayList<Entity> addEntityList = new ArrayList<Entity>();
        ArrayList<Property> addPropertyList = new ArrayList<Property>();
        HashMap<Property, Property> updatePropertyMap = new HashMap<Property, Property>();
        for (Entity entity : sourceEntityList) {
            Entity targetEntity = synchronizeTableStructureOption.target.getDatabaseEntity(entity.tableName);
            if (null == targetEntity) {
                addEntityList.add(entity);
                continue;
            }
            List<Property> sourcePropertyList = entity.properties;
            for (Property sourceProperty : sourcePropertyList) {
                Property targetProperty = targetEntity.properties.stream().filter(property -> property.column.equalsIgnoreCase(sourceProperty.column)).findFirst().orElse(null);
                if (null == targetProperty) {
                    addPropertyList.add(sourceProperty);
                    continue;
                }
                if (!synchronizeTableStructureOption.diffPropertyPredicate.test(sourceProperty, targetProperty)) continue;
                updatePropertyMap.put(sourceProperty, targetProperty);
            }
        }
        for (Entity entity : addEntityList) {
            if (null != synchronizeTableStructureOption.createTablePredicate && !synchronizeTableStructureOption.createTablePredicate.test(entity)) continue;
            synchronizeTableStructureOption.target.create(entity);
            if (!synchronizeTableStructureOption.executeSQL) continue;
            synchronizeTableStructureOption.target.create(entity);
        }
        for (Property property2 : addPropertyList) {
            if (null != synchronizeTableStructureOption.createPropertyPredicate && !synchronizeTableStructureOption.createPropertyPredicate.test(property2)) continue;
            synchronizeTableStructureOption.target.createColumn(property2.entity.tableName, property2);
            if (!synchronizeTableStructureOption.executeSQL) continue;
            synchronizeTableStructureOption.target.createColumn(property2.entity.tableName, property2);
        }
        Set propertyEntrySet = updatePropertyMap.entrySet();
        for (Map.Entry entry : propertyEntrySet) {
            if (null != synchronizeTableStructureOption.updatePropertyPredicate && !synchronizeTableStructureOption.updatePropertyPredicate.test((Property)entry.getKey(), (Property)entry.getValue())) continue;
            synchronizeTableStructureOption.target.alterColumn((Property)entry.getKey());
            if (!synchronizeTableStructureOption.executeSQL) continue;
            synchronizeTableStructureOption.target.alterColumn((Property)entry.getKey());
        }
    }

    private static void executeDatabaseUpgrade(DAO dao, DatabaseUpgrade databaseUpgrade) {
        dao.startTransaction(transaction -> {
            transaction.rawUpdate(databaseUpgrade.getSql(), new Object[0]);
            databaseUpgrade.setSuccess(true);
            transaction.update(databaseUpgrade);
        });
    }
}

